/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.undefined;

import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.ExpressionGridCache;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

public class SetCellValueCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final GridCellTuple cellTuple;
    private final Optional<String> nodeUUID;
    private final HasExpression hasExpression;
    private final Supplier<Optional<Expression>> expression;
    private final ExpressionGridCache expressionGridCache;
    private final ParameterizedCommand<Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>>> executeCanvasOperation;
    private final Command undoCanvasOperation;
    private final Supplier<Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>>> editorSupplier;
    private Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>> editor = Optional.empty();
    private final Optional<Expression> oldExpression;
    private final Optional<GridCellValue<?>> oldCellValue;

    public SetCellValueCommand(GridCellTuple cellTuple, Optional<String> nodeUUID, HasExpression hasExpression, Supplier<Optional<Expression>> expression, ExpressionGridCache expressionGridCache, ParameterizedCommand<Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>>> executeCanvasOperation, Command undoCanvasOperation, Supplier<Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>>> editorSupplier) {
        this.cellTuple = cellTuple;
        this.nodeUUID = nodeUUID;
        this.hasExpression = hasExpression;
        this.expression = expression;
        this.expressionGridCache = expressionGridCache;
        this.executeCanvasOperation = executeCanvasOperation;
        this.undoCanvasOperation = undoCanvasOperation;
        this.editorSupplier = editorSupplier;
        this.oldExpression = Optional.ofNullable(hasExpression.getExpression());
        this.oldCellValue = CommandUtils.extractGridCellValue(cellTuple);
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
                ((Optional)SetCellValueCommand.this.expression.get()).ifPresent(e -> {
                    SetCellValueCommand.this.hasExpression.setExpression(e);
                    e.setParent(SetCellValueCommand.this.hasExpression.asDMNModelInstrumentedBase());
                });
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
                SetCellValueCommand.this.hasExpression.setExpression((Expression)SetCellValueCommand.this.oldExpression.orElse(null));
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler context) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
                if (!SetCellValueCommand.this.editor.isPresent()) {
                    SetCellValueCommand.this.editor = (Optional)SetCellValueCommand.this.editorSupplier.get();
                }
                SetCellValueCommand.this.nodeUUID.ifPresent(uuid -> SetCellValueCommand.this.expressionGridCache.putExpressionGrid((String)uuid, SetCellValueCommand.this.editor));
                ExpressionCellValue value = new ExpressionCellValue(SetCellValueCommand.this.editor);
                GridData gridData = SetCellValueCommand.this.cellTuple.getGridWidget().getModel();
                gridData.setCellValue(SetCellValueCommand.this.cellTuple.getRowIndex(), SetCellValueCommand.this.cellTuple.getColumnIndex(), (GridCellValue)value);
                SetCellValueCommand.this.executeCanvasOperation.execute((Object)SetCellValueCommand.this.editor);
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
                SetCellValueCommand.this.nodeUUID.ifPresent(SetCellValueCommand.this.expressionGridCache::removeExpressionGrid);
                if (SetCellValueCommand.this.oldCellValue.isPresent()) {
                    SetCellValueCommand.this.cellTuple.getGridWidget().getModel().setCellValue(SetCellValueCommand.this.cellTuple.getRowIndex(), SetCellValueCommand.this.cellTuple.getColumnIndex(), (GridCellValue)SetCellValueCommand.this.oldCellValue.get());
                } else {
                    SetCellValueCommand.this.cellTuple.getGridWidget().getModel().deleteCell(SetCellValueCommand.this.cellTuple.getRowIndex(), SetCellValueCommand.this.cellTuple.getColumnIndex());
                }
                SetCellValueCommand.this.undoCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }
}

