/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.decision;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorItem;
import org.kie.workbench.common.dmn.client.decision.DecisionNavigatorPresenter;
import org.kie.workbench.common.dmn.client.decision.tree.DecisionNavigatorTreePresenter;
import org.kie.workbench.common.dmn.client.events.EditExpressionEvent;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasClearEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementAddedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementRemovedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementUpdatedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasFocusedShapeEvent;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;

@ApplicationScoped
public class DecisionNavigatorObserver {
    private DecisionNavigatorPresenter presenter;

    public void init(DecisionNavigatorPresenter presenter) {
        this.presenter = presenter;
    }

    void onCanvasClear(@Observes CanvasClearEvent event) {
        this.getOptionalPresenter().ifPresent(p -> {
            p.removeAllElements();
            p.refreshTreeView();
        });
    }

    void onCanvasElementAdded(@Observes CanvasElementAddedEvent event) {
        this.getOptionalPresenter().ifPresent(p -> p.addOrUpdateElement(event.getElement()));
    }

    void onCanvasElementUpdated(@Observes CanvasElementUpdatedEvent event) {
        this.getOptionalPresenter().ifPresent(p -> p.addOrUpdateElement(event.getElement()));
    }

    void onCanvasElementRemoved(@Observes CanvasElementRemovedEvent event) {
        this.getOptionalPresenter().ifPresent(p -> p.removeElement(event.getElement()));
    }

    void onNestedElementSelected(@Observes EditExpressionEvent event) {
        this.selectItem(event);
        this.setActiveParent(event);
    }

    void onNestedElementAdded(@Observes ExpressionEditorChanged event) {
        this.presenter.getGraph().ifPresent(this::updateNode);
    }

    private void updateNode(Graph graph) {
        String activeParent = this.getActiveParent().getUUID();
        Node node = graph.getNode(activeParent);
        this.presenter.updateElement((Element<?>)node);
        this.getActiveParent().getChildren().forEach(e -> this.getTreePresenter().selectItem(e.getUUID()));
    }

    void onNestedElementLostFocus(@Observes CanvasFocusedShapeEvent event) {
        this.getTreePresenter().deselectItem();
    }

    void selectItem(EditExpressionEvent event) {
        HasExpression hasExpression = event.getHasExpression();
        Optional<Expression> optionalExpression = Optional.ofNullable(hasExpression.getExpression());
        optionalExpression.ifPresent(expression -> {
            String value = expression.getId().getValue();
            this.getTreePresenter().selectItem(value);
        });
    }

    DecisionNavigatorItem getActiveParent() {
        return this.getTreePresenter().getActiveParent();
    }

    void setActiveParent(EditExpressionEvent event) {
        String uuid = event.getNodeUUID();
        this.getTreePresenter().setActiveParentUUID(uuid);
    }

    private DecisionNavigatorTreePresenter getTreePresenter() {
        return this.presenter.getTreePresenter();
    }

    private Optional<DecisionNavigatorPresenter> getOptionalPresenter() {
        return Optional.ofNullable(this.presenter);
    }
}

