/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.decision.included.components;

import com.google.gwt.event.dom.client.MouseDownEvent;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLHeadingElement;
import elemental2.dom.HTMLImageElement;
import elemental2.dom.HTMLParagraphElement;
import java.util.Objects;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.client.DMNShapeSet;
import org.kie.workbench.common.dmn.client.decision.included.components.DecisionComponentsItem;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.dmn.client.shape.factory.DMNShapeFactory;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.event.BuildCanvasShapeEvent;
import org.kie.workbench.common.stunner.core.client.components.drag.DragProxyCallback;
import org.kie.workbench.common.stunner.core.client.components.glyph.ShapeGlyphDragHandler;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
@Templated
public class DecisionComponentsItemView
implements DecisionComponentsItem.View {
    @DataField(value="icon")
    private final HTMLImageElement icon;
    @DataField(value="name")
    private final HTMLHeadingElement name;
    @DataField(value="decision-component-item")
    private final HTMLDivElement decisionComponentItem;
    @DataField(value="file")
    private final HTMLParagraphElement file;
    private DecisionComponentsItem presenter;
    private final DMNShapeSet dmnShapeSet;
    private final SessionManager sessionManager;
    private final ShapeGlyphDragHandler<?> shapeGlyphDragHandler;
    private final Event<BuildCanvasShapeEvent> buildCanvasShapeEvent;
    private final Event<NotificationEvent> notificationEvent;
    private final ClientTranslationService clientTranslationService;
    private final DMNGraphUtils dmnGraphUtils;

    @Inject
    public DecisionComponentsItemView(HTMLImageElement icon, @Named(value="h5") HTMLHeadingElement name, HTMLParagraphElement file, DMNShapeSet dmnShapeSet, SessionManager sessionManager, ShapeGlyphDragHandler<?> shapeGlyphDragHandler, Event<BuildCanvasShapeEvent> buildCanvasShapeEvent, HTMLDivElement decisionComponentItem, Event<NotificationEvent> notificationEvent, ClientTranslationService clientTranslationService, DMNGraphUtils dmnGraphUtils) {
        this.icon = icon;
        this.name = name;
        this.file = file;
        this.dmnShapeSet = dmnShapeSet;
        this.sessionManager = sessionManager;
        this.shapeGlyphDragHandler = shapeGlyphDragHandler;
        this.buildCanvasShapeEvent = buildCanvasShapeEvent;
        this.decisionComponentItem = decisionComponentItem;
        this.notificationEvent = notificationEvent;
        this.clientTranslationService = clientTranslationService;
        this.dmnGraphUtils = dmnGraphUtils;
    }

    public void init(DecisionComponentsItem presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setIcon(String iconURI) {
        this.icon.src = iconURI;
    }

    @Override
    public void setName(String name) {
        this.name.textContent = name;
    }

    @Override
    public void setFile(String file) {
        this.file.textContent = file;
    }

    @EventHandler(value={"decision-component-item"})
    public void decisionComponentItemMouseDown(MouseDownEvent mouseDownEvent) {
        DRGElement drgElement = this.presenter.getDrgElement();
        DMNShapeFactory factory = this.dmnShapeSet.getShapeFactory();
        Glyph glyph = factory.getGlyph(drgElement.getClass().getName());
        ShapeGlyphDragHandler.Item item = this.makeDragHandler(glyph);
        DragProxyCallback proxy = this.makeDragProxyCallbackImpl(drgElement, factory);
        this.shapeGlyphDragHandler.show((Object)item, mouseDownEvent.getX(), mouseDownEvent.getY(), (Object)proxy);
    }

    DragProxyCallback makeDragProxyCallbackImpl(DRGElement drgElement, ShapeFactory factory) {
        return new DragProxyCallbackImpl(drgElement, factory, this.sessionManager, this.notificationEvent, this.clientTranslationService, this.dmnGraphUtils);
    }

    ShapeGlyphDragHandler.Item makeDragHandler(Glyph glyph) {
        return new DragHandler(glyph);
    }

    class DragHandler
    implements ShapeGlyphDragHandler.Item {
        private final Glyph glyph;

        DragHandler(Glyph glyph) {
            this.glyph = glyph;
        }

        public Glyph getShape() {
            return this.glyph;
        }

        public int getWidth() {
            return 16;
        }

        public int getHeight() {
            return 16;
        }
    }

    class DragProxyCallbackImpl
    implements DragProxyCallback {
        private final DRGElement drgElement;
        private final ShapeFactory<?, ?> factory;
        private final SessionManager sessionManager;
        private final Event<NotificationEvent> notificationEvent;
        private final ClientTranslationService clientTranslationService;
        private final DMNGraphUtils dmnGraphUtils;

        DragProxyCallbackImpl(DRGElement drgElement, ShapeFactory factory, SessionManager sessionManager, Event<NotificationEvent> notificationEvent, ClientTranslationService clientTranslationService, DMNGraphUtils dmnGraphUtils) {
            this.drgElement = drgElement;
            this.factory = factory;
            this.sessionManager = sessionManager;
            this.notificationEvent = notificationEvent;
            this.clientTranslationService = clientTranslationService;
            this.dmnGraphUtils = dmnGraphUtils;
        }

        public void onStart(int x, int y) {
        }

        public void onMove(int x, int y) {
        }

        public void onComplete(int x, int y) {
            if (this.isDuplicatedNode(this.drgElement)) {
                this.fireDuplicatedNodeWarningMessage();
            } else {
                this.fireBuildShapeEvent(x, y);
            }
        }

        private boolean isDuplicatedNode(DRGElement drgElement) {
            return this.dmnGraphUtils.getDefinitions().getDrgElement().stream().map(element -> element.getId().getValue()).anyMatch(drgElementId -> Objects.equals(drgElementId, drgElement.getId().getValue()));
        }

        private void fireDuplicatedNodeWarningMessage() {
            String message = this.clientTranslationService.getValue("DecisionComponentsItemView.DuplicatedNode");
            this.notificationEvent.fire((Object)new NotificationEvent(message, NotificationEvent.NotificationType.WARNING));
        }

        private void fireBuildShapeEvent(int x, int y) {
            DecisionComponentsItemView.this.buildCanvasShapeEvent.fire((Object)new BuildCanvasShapeEvent(this.getCanvasHandler(), (Object)this.drgElement, this.factory, (double)x, (double)y));
        }

        private AbstractCanvasHandler getCanvasHandler() {
            return (AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler();
        }
    }
}

