/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.context;

import com.ait.lienzo.shared.core.types.EventPropagationMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.event.Event;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.Context;
import org.kie.workbench.common.dmn.api.definition.v1_1.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.commands.expressions.types.context.AddContextEntryCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.context.ClearExpressionTypeCommand;
import org.kie.workbench.common.dmn.client.commands.expressions.types.context.DeleteContextEntryCommand;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGridData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextGridRowNumberColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextUIModelMapperHelper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionCellValue;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ExpressionEditorColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.NameColumn;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.NameColumnHeaderMetaData;
import org.kie.workbench.common.dmn.client.editors.expressions.types.undefined.UndefinedExpressionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.util.SelectionUtils;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGridRenderer;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorGridRow;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.dmn.client.widgets.grid.model.HasRowDragRestrictions;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.dmn.client.widgets.panel.DMNGridPanel;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseHeaderMetaData;
import org.uberfire.ext.wires.core.grids.client.widget.dnd.GridWidgetDnDHandlersState;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridWidgetRegistry;

public class ContextGrid
extends BaseExpressionGrid<Context, ContextGridData, ContextUIModelMapper>
implements HasRowDragRestrictions,
HasListSelectorControl {
    private final Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    private final NameAndDataTypePopoverView.Presenter headerEditor;

    public ContextGrid(GridCellTuple parent, Optional<String> nodeUUID, HasExpression hasExpression, Optional<HasName> hasName, DMNGridPanel gridPanel, DMNGridLayer gridLayer, ContextGridData gridData, DefinitionUtils definitionUtils, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, DefaultCanvasCommandFactory canvasCommandFactory, Event<ExpressionEditorChanged> editorSelectedEvent, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent, CellEditorControlsView.Presenter cellEditorControls, ListSelectorView.Presenter listSelector, TranslationService translationService, boolean isOnlyVisualChangeAllowed, int nesting, Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, NameAndDataTypePopoverView.Presenter headerEditor) {
        super(parent, nodeUUID, hasExpression, hasName, gridPanel, gridLayer, gridData, (GridRenderer)new BaseExpressionGridRenderer(gridData), definitionUtils, sessionManager, sessionCommandManager, canvasCommandFactory, editorSelectedEvent, refreshFormPropertiesEvent, domainObjectSelectionEvent, cellEditorControls, listSelector, translationService, isOnlyVisualChangeAllowed, nesting);
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
        this.headerEditor = headerEditor;
        this.setEventPropagationMode(EventPropagationMode.NO_ANCESTORS);
        super.doInitialisation();
    }

    @Override
    protected void doInitialisation() {
    }

    @Override
    public ContextUIModelMapper makeUiModelMapper() {
        return new ContextUIModelMapper((GridWidget)this, () -> ((ContextGrid)this).getModel(), this.getExpression(), () -> this.isOnlyVisualChangeAllowed, this.expressionEditorDefinitionsSupplier, this.listSelector, this.nesting);
    }

    @Override
    public void initialiseUiColumns() {
        ArrayList<GridColumn.HeaderMetaData> headerMetaData = new ArrayList<GridColumn.HeaderMetaData>();
        ContextGridRowNumberColumn rowNumberColumn = new ContextGridRowNumberColumn(headerMetaData, this.getAndSetInitialWidth(0, 50.0));
        if (this.nesting == 0) {
            rowNumberColumn.getHeaderMetaData().add(new BaseHeaderMetaData("#"));
            headerMetaData.add(new NameColumnHeaderMetaData(this.hasExpression, this.hasName, this.clearDisplayNameConsumer(true), this.setDisplayNameConsumer(true), this.setTypeRefConsumer(), this.cellEditorControls, this.headerEditor, Optional.of(this.translationService.getTranslation("ContextEditor.EditExpression")), this.listSelector, this::getHeaderItems, this::onItemSelected));
        }
        NameColumn nameColumn = new NameColumn((List<GridColumn.HeaderMetaData>)headerMetaData, this.getAndSetInitialWidth(1, 100.0), this, rowIndex -> rowIndex != this.getModel().getRowCount() - 1, this.clearDisplayNameConsumer(false), this.setDisplayNameConsumer(false), this.setTypeRefConsumer(), this.cellEditorControls, this.headerEditor, Optional.of(this.translationService.getTranslation("ContextEditor.EditContextEntry")));
        ExpressionEditorColumn expressionColumn = new ExpressionEditorColumn((GridWidgetRegistry)this.gridLayer, headerMetaData, this.getAndSetInitialWidth(2, 150.0), (BaseGrid<? extends Expression>)this);
        this.model.appendColumn((GridColumn)rowNumberColumn);
        this.model.appendColumn((GridColumn)nameColumn);
        this.model.appendColumn((GridColumn)expressionColumn);
        this.getRenderer().setColumnRenderConstraint((isSelectionLayer, gridColumn) -> isSelectionLayer == false || gridColumn.equals((Object)expressionColumn));
    }

    @Override
    public void initialiseUiModel() {
        this.getExpression().get().ifPresent(c -> c.getContextEntry().stream().forEach(ce -> {
            this.model.appendRow((GridRow)new ExpressionEditorGridRow());
            ((ContextUIModelMapper)this.uiModelMapper).fromDMNModel(this.model.getRowCount() - 1, 0);
            ((ContextUIModelMapper)this.uiModelMapper).fromDMNModel(this.model.getRowCount() - 1, 1);
            ((ContextUIModelMapper)this.uiModelMapper).fromDMNModel(this.model.getRowCount() - 1, 2);
        }));
    }

    @Override
    public boolean isRowDragPermitted(GridWidgetDnDHandlersState state) {
        GridWidgetDnDHandlersState.GridWidgetHandlersOperation operation = state.getOperation();
        if (operation == GridWidgetDnDHandlersState.GridWidgetHandlersOperation.ROW_MOVE_PENDING) {
            int lastRowIndex = this.model.getRowCount() - 1;
            List rows = state.getActiveGridRows();
            return !rows.contains(this.model.getRow(lastRowIndex));
        }
        return true;
    }

    List<HasListSelectorControl.ListSelectorItem> getHeaderItems(int uiHeaderRowIndex, int uiHeaderColumnIndex) {
        ArrayList<HasListSelectorControl.ListSelectorItem> items = new ArrayList<HasListSelectorControl.ListSelectorItem>();
        items.add(HasListSelectorControl.ListSelectorHeaderItem.build(this.translationService.format("ContextEditor.Header", new Object[0])));
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("ContextEditor.InsertContextEntry", new Object[0]), true, () -> {
            this.cellEditorControls.hide();
            this.getExpression().get().ifPresent(e -> this.addContextEntry(this.model.getRowCount() - 1));
        }));
        return items;
    }

    @Override
    public List<HasListSelectorControl.ListSelectorItem> getItems(int uiRowIndex, int uiColumnIndex) {
        ArrayList<HasListSelectorControl.ListSelectorItem> items = new ArrayList<HasListSelectorControl.ListSelectorItem>();
        boolean isMultiRow = SelectionUtils.isMultiRow(this.model);
        boolean isMultiSelect = SelectionUtils.isMultiSelect(this.model);
        if (uiRowIndex < this.model.getRowCount() - 1) {
            items.add(HasListSelectorControl.ListSelectorHeaderItem.build(this.translationService.format("ContextEditor.Header", new Object[0])));
            items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("ContextEditor.InsertContextEntryAbove", new Object[0]), !isMultiRow, () -> {
                this.cellEditorControls.hide();
                this.getExpression().get().ifPresent(e -> this.addContextEntry(uiRowIndex));
            }));
            items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("ContextEditor.InsertContextEntryBelow", new Object[0]), !isMultiRow, () -> {
                this.cellEditorControls.hide();
                this.getExpression().get().ifPresent(e -> this.addContextEntry(uiRowIndex + 1));
            }));
            items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("ContextEditor.DeleteContextEntry", new Object[0]), !isMultiRow && this.model.getRowCount() > 2 && uiRowIndex < this.model.getRowCount() - 1, () -> {
                this.cellEditorControls.hide();
                this.deleteContextEntry(uiRowIndex);
            }));
        }
        if (ContextUIModelMapperHelper.getSection(uiColumnIndex) != ContextUIModelMapperHelper.ContextSection.EXPRESSION) {
            return items;
        }
        GridCell cell = this.model.getCell(uiRowIndex, uiColumnIndex);
        ExpressionCellValue ecv = (ExpressionCellValue)cell.getValue();
        if (!((Optional)ecv.getValue()).isPresent()) {
            return items;
        }
        BaseExpressionGrid grid = (BaseExpressionGrid)((Optional)ecv.getValue()).get();
        if (grid instanceof UndefinedExpressionGrid) {
            return items;
        }
        if (items.size() > 0) {
            items.add(new HasListSelectorControl.ListSelectorDividerItem());
        }
        items.add(HasListSelectorControl.ListSelectorTextItem.build(this.translationService.format("ExpressionEditor.Clear", new Object[0]), !isMultiSelect, () -> {
            this.cellEditorControls.hide();
            this.clearExpressionType(uiRowIndex);
        }));
        return items;
    }

    @Override
    public void onItemSelected(HasListSelectorControl.ListSelectorItem item) {
        HasListSelectorControl.ListSelectorTextItem li = (HasListSelectorControl.ListSelectorTextItem)item;
        li.getCommand().execute();
    }

    void addContextEntry(int index) {
        this.getExpression().get().ifPresent(c -> {
            ContextEntry ce = new ContextEntry();
            InformationItem informationItem = new InformationItem();
            informationItem.setName(new Name());
            ce.setVariable(informationItem);
            CommandResult result = this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new AddContextEntryCommand((Context)c, ce, this.model, (GridRow)new ExpressionEditorGridRow(), index, (ContextUIModelMapper)this.uiModelMapper, () -> this.resize(BaseExpressionGrid.RESIZE_EXISTING)));
            if (!CommandUtils.isError((CommandResult)result)) {
                this.selectCell(index, 1, false, false);
                this.startEditingCell(index, 1);
            }
        });
    }

    void deleteContextEntry(int index) {
        this.getExpression().get().ifPresent(c -> this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new DeleteContextEntryCommand((Context)c, this.model, index, () -> this.resize(BaseExpressionGrid.RESIZE_EXISTING))));
    }

    void clearExpressionType(int uiRowIndex) {
        GridCellTuple gc = new GridCellTuple(uiRowIndex, 2, (GridWidget)this);
        this.getExpression().get().ifPresent(context -> {
            HasExpression hasExpression = (HasExpression)context.getContextEntry().get(uiRowIndex);
            this.sessionCommandManager.execute((Object)((AbstractCanvasHandler)this.sessionManager.getCurrentSession().getCanvasHandler()), (Command)new ClearExpressionTypeCommand(gc, hasExpression, (ContextUIModelMapper)this.uiModelMapper, () -> {
                this.resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
                this.selectExpressionEditorFirstCell(uiRowIndex, 2);
            }, () -> {
                this.resize(BaseExpressionGrid.RESIZE_EXISTING_MINIMUM);
                this.selectExpressionEditorFirstCell(uiRowIndex, 2);
            }));
        });
    }

    @Override
    public void doAfterSelectionChange(int uiRowIndex, int uiColumnIndex) {
        if (this.hasAnyHeaderCellSelected() || this.hasMultipleRowsSelected()) {
            super.doAfterSelectionChange(uiRowIndex, uiColumnIndex);
            return;
        }
        if (uiRowIndex < this.model.getRowCount() - 1 && this.getExpression().get().isPresent()) {
            Context context = (Context)this.getExpression().get().get();
            this.fireDomainObjectSelectionEvent((DomainObject)((ContextEntry)context.getContextEntry().get(uiRowIndex)).getVariable());
            return;
        }
        super.doAfterSelectionChange(uiRowIndex, uiColumnIndex);
    }

    private boolean hasMultipleRowsSelected() {
        return this.getModel().getSelectedCells().stream().map(GridData.SelectedCell::getRowIndex).distinct().count() > 1L;
    }

    @Override
    public void doAfterHeaderSelectionChange(int uiHeaderRowIndex, int uiHeaderColumnIndex) {
        DMNModelInstrumentedBase base;
        if ((uiHeaderColumnIndex == 1 || uiHeaderColumnIndex == 2) && (base = this.hasExpression.asDMNModelInstrumentedBase()) instanceof DomainObject) {
            this.fireDomainObjectSelectionEvent((DomainObject)base);
            return;
        }
        super.doAfterHeaderSelectionChange(uiHeaderRowIndex, uiHeaderColumnIndex);
    }
}

