/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy;

import com.google.gwt.core.client.Scheduler;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.definition.v1_1.BuiltinAggregator;
import org.kie.workbench.common.dmn.api.definition.v1_1.HitPolicy;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.BuiltinAggregatorUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.HitPolicyPopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.popover.AbstractPopoverViewImpl;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.client.views.pfly.widgets.Select;
import org.uberfire.mvp.Command;

@Templated
@ApplicationScoped
public class HitPolicyPopoverViewImpl
extends AbstractPopoverViewImpl
implements HitPolicyPopoverView {
    @DataField(value="lstHitPolicies")
    private Select lstHitPolicies;
    @DataField(value="lstBuiltinAggregator")
    private Select lstBuiltinAggregator;
    @DataField(value="hitPolicyLabel")
    private Span hitPolicyLabel;
    @DataField(value="builtinAggregatorLabel")
    private Span builtinAggregatorLabel;
    private BuiltinAggregatorUtils builtinAggregatorUtils;
    private HitPolicyPopoverView.Presenter presenter;

    public HitPolicyPopoverViewImpl() {
    }

    @Inject
    public HitPolicyPopoverViewImpl(Select lstHitPolicies, Select lstBuiltinAggregator, BuiltinAggregatorUtils builtinAggregatorUtils, Div popoverElement, Div popoverContentElement, Span hitPolicyLabel, Span builtinAggregatorLabel, JQueryProducer.JQuery<Popover> jQueryPopover, TranslationService translationService) {
        super(popoverElement, popoverContentElement, jQueryPopover);
        this.lstHitPolicies = lstHitPolicies;
        this.lstBuiltinAggregator = lstBuiltinAggregator;
        this.builtinAggregatorUtils = builtinAggregatorUtils;
        this.hitPolicyLabel = hitPolicyLabel;
        this.builtinAggregatorLabel = builtinAggregatorLabel;
        this.hitPolicyLabel.setTextContent(translationService.getTranslation("DecisionTableEditor.HitPolicyLabel"));
        this.builtinAggregatorLabel.setTextContent(translationService.getTranslation("DecisionTableEditor.BuiltinAggregatorLabel"));
        this.setupHitPolicyEventHandler();
        this.setupBuiltinAggregatorEventHandler();
    }

    private void setupHitPolicyEventHandler() {
        this.setupChangeEventHandler(this.lstHitPolicies, () -> {
            HitPolicy hp = HitPolicy.fromValue((String)this.lstHitPolicies.getValue());
            this.presenter.setHitPolicy(hp);
        });
    }

    private void setupBuiltinAggregatorEventHandler() {
        this.setupChangeEventHandler(this.lstBuiltinAggregator, () -> {
            BuiltinAggregator aggregator = this.builtinAggregatorUtils.toEnum(this.lstBuiltinAggregator.getValue());
            this.presenter.setBuiltinAggregator(aggregator);
        });
    }

    private void setupChangeEventHandler(Select select, Command command) {
        select.getElement().addEventListener("change", event -> command.execute(), false);
    }

    public void init(HitPolicyPopoverView.Presenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void initHitPolicies(List<HitPolicy> hitPolicies) {
        hitPolicies.forEach(hp -> this.lstHitPolicies.addOption(hp.value()));
    }

    @Override
    public void initBuiltinAggregators(List<BuiltinAggregator> aggregators) {
        aggregators.forEach(a -> this.lstBuiltinAggregator.addOption(this.builtinAggregatorUtils.toString((BuiltinAggregator)a)));
    }

    @Override
    public void initSelectedHitPolicy(HitPolicy hitPolicy) {
        this.initSelect(this.lstHitPolicies, hitPolicy.value());
    }

    @Override
    public void initSelectedBuiltinAggregator(BuiltinAggregator aggregator) {
        this.initSelect(this.lstBuiltinAggregator, this.builtinAggregatorUtils.toString(aggregator));
    }

    private void initSelect(Select select, String value) {
        Scheduler.get().scheduleDeferred(() -> select.refresh(s -> s.setValue(value)));
    }

    private void enableSelect(Select select, boolean enabled) {
        if (enabled) {
            select.enable();
        } else {
            select.disable();
        }
    }

    @Override
    public void enableHitPolicies(boolean enabled) {
        this.enableSelect(this.lstHitPolicies, enabled);
    }

    @Override
    public void enableBuiltinAggregators(boolean enabled) {
        this.enableSelect(this.lstBuiltinAggregator, enabled);
    }
}

