/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.invocation;

import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.v1_1.Binding;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationItem;
import org.kie.workbench.common.dmn.api.definition.v1_1.Invocation;
import org.kie.workbench.common.dmn.api.definition.v1_1.LiteralExpression;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.editors.expressions.types.BaseEditorDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionEditorDefinitions;
import org.kie.workbench.common.dmn.client.editors.expressions.types.ExpressionType;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationDefaultValueUtilities;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.invocation.InvocationGridData;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.BaseExpressionGrid;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;
import org.kie.workbench.common.dmn.client.widgets.grid.model.BaseUIModelMapper;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridData;
import org.kie.workbench.common.dmn.client.widgets.grid.model.ExpressionEditorChanged;
import org.kie.workbench.common.dmn.client.widgets.grid.model.GridCellTuple;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.uberfire.ext.wires.core.grids.client.model.GridData;

@ApplicationScoped
public class InvocationEditorDefinition
extends BaseEditorDefinition<Invocation, InvocationGridData> {
    private Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier;
    private NameAndDataTypePopoverView.Presenter headerEditor;

    public InvocationEditorDefinition() {
    }

    @Inject
    public InvocationEditorDefinition(DefinitionUtils definitionUtils, SessionManager sessionManager, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, @DMNEditor DefaultCanvasCommandFactory canvasCommandFactory, Event<ExpressionEditorChanged> editorSelectedEvent, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent, ListSelectorView.Presenter listSelector, TranslationService translationService, @DMNEditor Supplier<ExpressionEditorDefinitions> expressionEditorDefinitionsSupplier, NameAndDataTypePopoverView.Presenter headerEditor) {
        super(definitionUtils, sessionManager, sessionCommandManager, canvasCommandFactory, editorSelectedEvent, refreshFormPropertiesEvent, domainObjectSelectionEvent, listSelector, translationService);
        this.expressionEditorDefinitionsSupplier = expressionEditorDefinitionsSupplier;
        this.headerEditor = headerEditor;
    }

    @Override
    public ExpressionType getType() {
        return ExpressionType.INVOCATION;
    }

    @Override
    public String getName() {
        return this.translationService.format("ExpressionEditor.InvocationType", new Object[0]);
    }

    @Override
    public Optional<Invocation> getModelClass() {
        return Optional.of(new Invocation());
    }

    @Override
    public void enrich(Optional<String> nodeUUID, HasExpression hasExpression, Optional<Invocation> expression) {
        expression.ifPresent(invocation -> {
            LiteralExpression literalExpression = new LiteralExpression();
            invocation.setExpression((Expression)literalExpression);
            InformationItem parameter = new InformationItem();
            parameter.getName().setValue(InvocationDefaultValueUtilities.getNewParameterName(invocation));
            Binding binding = new Binding();
            binding.setParameter(parameter);
            invocation.getBinding().add(binding);
            literalExpression.setParent((DMNModelInstrumentedBase)invocation);
            binding.setParent((DMNModelInstrumentedBase)invocation);
            parameter.setParent((DMNModelInstrumentedBase)binding);
        });
    }

    @Override
    public Optional<BaseExpressionGrid<? extends Expression, ? extends GridData, ? extends BaseUIModelMapper>> getEditor(GridCellTuple parent, Optional<String> nodeUUID, HasExpression hasExpression, Optional<HasName> hasName, boolean isOnlyVisualChangeAllowed, int nesting) {
        return Optional.of(new InvocationGrid(parent, nodeUUID, hasExpression, hasName, this.getGridPanel(), this.getGridLayer(), (InvocationGridData)this.makeGridData(() -> Optional.ofNullable((Invocation)hasExpression.getExpression())), this.definitionUtils, this.sessionManager, (SessionCommandManager<AbstractCanvasHandler>)this.sessionCommandManager, this.canvasCommandFactory, (Event<ExpressionEditorChanged>)this.editorSelectedEvent, (Event<RefreshFormPropertiesEvent>)this.refreshFormPropertiesEvent, (Event<DomainObjectSelectionEvent>)this.domainObjectSelectionEvent, this.getCellEditorControls(), this.listSelector, this.translationService, isOnlyVisualChangeAllowed, nesting, this.expressionEditorDefinitionsSupplier, this.headerEditor));
    }

    @Override
    protected InvocationGridData makeGridData(Supplier<Optional<Invocation>> expression) {
        return new InvocationGridData(new DMNGridData(), this.sessionManager, (SessionCommandManager<AbstractCanvasHandler>)this.sessionCommandManager, expression, this.getGridLayer()::batch);
    }
}

