/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.grid;

import com.google.gwt.dom.client.Style;
import elemental2.dom.HTMLElement;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.client.decision.events.RefreshDecisionComponents;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.client.editors.included.grid.DMNCardsGridComponent;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.kie.workbench.common.widgets.client.cards.CardComponent;
import org.uberfire.client.mvp.UberElemental;

public class DMNCardComponent
implements CardComponent {
    private final ContentView contentView;
    private final Event<RefreshDecisionComponents> refreshDecisionComponentsEvent;
    private DMNCardsGridComponent grid;
    private IncludedModel includedModel;

    @Inject
    public DMNCardComponent(ContentView contentView, Event<RefreshDecisionComponents> refreshDecisionComponentsEvent) {
        this.contentView = contentView;
        this.refreshDecisionComponentsEvent = refreshDecisionComponentsEvent;
    }

    @PostConstruct
    public void init() {
        this.contentView.init(this);
    }

    public void setup(DMNCardsGridComponent grid, IncludedModel includedModel) {
        this.grid = grid;
        this.includedModel = includedModel;
        this.refreshView();
    }

    void refreshView() {
        this.contentView.setPath(this.getTruncatedSubTitle());
        this.contentView.setDataTypesCount(this.getDataTypesCount());
        this.contentView.setDrgElementsCount(this.getDrgElementsCount());
    }

    public Style.HasCssName getIcon() {
        return IconType.DOWNLOAD;
    }

    public String getTitle() {
        return this.getIncludedModel().getName();
    }

    public String getUUID() {
        return this.getIncludedModel().getUUID();
    }

    public HTMLElement getContent() {
        return this.contentView.getElement();
    }

    public Function<String, Boolean> onTitleChanged() {
        return newName -> {
            String oldName = this.getIncludedModel().getName();
            this.getIncludedModel().setName((String)newName);
            if (this.getIncludedModel().isValid()) {
                this.getIncludedModel().update();
                this.getGrid().refresh();
                this.refreshDecisionComponents();
                return true;
            }
            this.getIncludedModel().setName(oldName);
            return false;
        };
    }

    private String getTruncatedSubTitle() {
        return this.truncate(this.getSubTitle(), 60);
    }

    String getSubTitle() {
        if (StringUtils.isEmpty((String)this.getIncludedModel().getPath())) {
            return this.getIncludedModel().getNamespace();
        }
        return this.getIncludedModel().getPath();
    }

    String truncate(String value, int limit) {
        if (value.length() > limit) {
            return "..." + value.substring(value.length() - limit);
        }
        return value;
    }

    private Integer getDataTypesCount() {
        return this.getIncludedModel().getDataTypesCount();
    }

    private Integer getDrgElementsCount() {
        return this.getIncludedModel().getDrgElementsCount();
    }

    public void remove() {
        this.getIncludedModel().destroy();
        this.getGrid().refresh();
        this.refreshDecisionComponents();
    }

    void refreshDecisionComponents() {
        this.refreshDecisionComponentsEvent.fire((Object)new RefreshDecisionComponents());
    }

    IncludedModel getIncludedModel() {
        return this.includedModel;
    }

    DMNCardsGridComponent getGrid() {
        return this.grid;
    }

    public static interface ContentView
    extends UberElemental<DMNCardComponent>,
    IsElement {
        public void setPath(String var1);

        public void setDataTypesCount(Integer var1);

        public void setDrgElementsCount(Integer var1);
    }
}

