/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.grid;

import elemental2.dom.HTMLElement;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPageState;
import org.kie.workbench.common.dmn.client.editors.included.grid.DMNCardComponent;
import org.kie.workbench.common.dmn.client.editors.included.grid.empty.DMNCardsEmptyStateView;
import org.kie.workbench.common.widgets.client.cards.CardComponent;
import org.kie.workbench.common.widgets.client.cards.CardsGridComponent;

public class DMNCardsGridComponent {
    private final ManagedInstance<DMNCardComponent> dmnCardComponent;
    private final CardsGridComponent cardsGridComponent;
    private final IncludedModelsPageState pageState;
    private final DMNCardsEmptyStateView emptyStateView;

    @Inject
    public DMNCardsGridComponent(ManagedInstance<DMNCardComponent> dmnCardComponent, CardsGridComponent cardsGridComponent, IncludedModelsPageState pageState, DMNCardsEmptyStateView emptyStateView) {
        this.dmnCardComponent = dmnCardComponent;
        this.cardsGridComponent = cardsGridComponent;
        this.pageState = pageState;
        this.emptyStateView = emptyStateView;
    }

    @PostConstruct
    public void init() {
        this.cardsGridComponent.setEmptyState(this.emptyStateView.getElement());
    }

    public void refresh() {
        this.cardsGridComponent.setupCards(this.dmnCards(this.generateIncludedModels()));
    }

    public HTMLElement getElement() {
        return this.cardsGridComponent.getElement();
    }

    private List<CardComponent> dmnCards(List<IncludedModel> includes) {
        return includes.stream().map(this::dmnCard).collect(Collectors.toList());
    }

    private DMNCardComponent dmnCard(IncludedModel includedModel) {
        DMNCardComponent card = (DMNCardComponent)this.dmnCardComponent.get();
        card.setup(this, includedModel);
        return card;
    }

    private List<IncludedModel> generateIncludedModels() {
        return this.pageState.generateIncludedModels();
    }
}

