/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports;

import java.util.Objects;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.Import;
import org.kie.workbench.common.dmn.api.property.dmn.LocationURI;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsIndex;

public class ImportFactory {
    static String IMPORT_TYPE = "http://www.omg.org/spec/DMN/20180521/MODEL/";
    private final IncludedModelsIndex modelsIndex;

    @Inject
    public ImportFactory(IncludedModelsIndex modelsIndex) {
        this.modelsIndex = modelsIndex;
    }

    public Import makeImport(IncludedModel record) {
        Import anImport = new Import();
        anImport.setImportType(IMPORT_TYPE);
        anImport.setName(this.name(record));
        anImport.setLocationURI(this.location(record));
        anImport.setNamespace(record.getNamespace());
        anImport.setDrgElementsCount(record.getDrgElementsCount().intValue());
        anImport.setItemDefinitionsCount(record.getDataTypesCount().intValue());
        return anImport;
    }

    private LocationURI location(IncludedModel record) {
        return new LocationURI(record.getPath());
    }

    Name name(IncludedModel record) {
        return new Name(this.uniqueName(record.getName()));
    }

    private String uniqueName(String name) {
        return this.uniqueName(name, 1);
    }

    private String uniqueName(String name, int suffix) {
        String newName;
        String string = newName = suffix == 1 ? name : name + " - " + suffix;
        if (this.isUnique(newName)) {
            return newName;
        }
        return this.uniqueName(name, suffix + 1);
    }

    private boolean isUnique(String name) {
        return this.modelsIndex.getIndexedImports().stream().map(anImport -> anImport.getName().getValue()).noneMatch(importName -> Objects.equals(importName, name));
    }
}

