/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports;

import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.Import;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsIndex;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.ImportRecordEngine;
import org.uberfire.commons.uuid.UUID;

@ApplicationScoped
public class IncludedModelsFactory {
    private final ImportRecordEngine recordEngine;
    private final IncludedModelsIndex includedModelsIndex;

    @Inject
    public IncludedModelsFactory(ImportRecordEngine recordEngine, IncludedModelsIndex includedModelsIndex) {
        this.recordEngine = recordEngine;
        this.includedModelsIndex = includedModelsIndex;
    }

    List<IncludedModel> makeIncludedModels(List<Import> imports) {
        this.getIncludedModelsIndex().clear();
        return imports.stream().map(this::makeIncludedModel).collect(Collectors.toList());
    }

    private IncludedModel makeIncludedModel(Import anImport) {
        IncludedModel includedModel = new IncludedModel(this.getRecordEngine());
        includedModel.setUuid(UUID.uuid());
        includedModel.setName(this.getName(anImport));
        includedModel.setNamespace(this.getNamespace(anImport));
        includedModel.setPath(this.getPath(anImport));
        includedModel.setDataTypesCount(this.getDataTypesCount(anImport));
        includedModel.setDrgElementsCount(this.getDrgElementsCount(anImport));
        this.getIncludedModelsIndex().index(includedModel, anImport);
        return includedModel;
    }

    public IncludedModelsIndex getIncludedModelsIndex() {
        return this.includedModelsIndex;
    }

    public ImportRecordEngine getRecordEngine() {
        return this.recordEngine;
    }

    private String getName(Import anImport) {
        return anImport.getName().getValue();
    }

    private String getPath(Import anImport) {
        return anImport.getLocationURI().getValue();
    }

    private String getNamespace(Import anImport) {
        return anImport.getNamespace();
    }

    private int getDataTypesCount(Import anImport) {
        return anImport.getItemDefinitionsCount();
    }

    private int getDrgElementsCount(Import anImport) {
        return anImport.getDrgElementsCount();
    }
}

