/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports.persistence;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.HasVariable;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.IsInformationItem;
import org.kie.workbench.common.dmn.api.property.dmn.Id;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.api.qualifiers.DMNEditor;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

public class DRGElementHandler {
    private final DMNGraphUtils dmnGraphUtils;
    private final DefaultCanvasCommandFactory canvasCommandFactory;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final DefinitionUtils definitionUtils;

    @Inject
    public DRGElementHandler(DMNGraphUtils dmnGraphUtils, @DMNEditor DefaultCanvasCommandFactory canvasCommandFactory, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, DefinitionUtils definitionUtils) {
        this.dmnGraphUtils = dmnGraphUtils;
        this.canvasCommandFactory = canvasCommandFactory;
        this.sessionCommandManager = sessionCommandManager;
        this.definitionUtils = definitionUtils;
    }

    public void update(String oldModelName, String newModelName) {
        this.updateDRGElementsVariableAndId(oldModelName, newModelName);
        this.findDRGElementsByOldName(oldModelName).forEach(drgElement -> {
            String oldName = drgElement.getName().getValue();
            String newName = oldName.replaceAll("^" + oldModelName, newModelName);
            this.updateDRGElementName((DRGElement)drgElement, newName);
        });
    }

    public void destroy(String oldModelName) {
        this.findDRGElementsByOldName(oldModelName).forEach(this::deleteDRGElement);
    }

    private List<DRGElement> findDRGElementsByOldName(String oldModelName) {
        return this.dmnGraphUtils.getDRGElements().stream().filter(drgElement -> this.drgElementNameStartsWith(oldModelName, (DRGElement)drgElement)).filter(DRGElement::isAllowOnlyVisualChange).collect(Collectors.toList());
    }

    private void updateDRGElementsVariableAndId(String oldModelName, String newModelName) {
        this.dmnGraphUtils.getDRGElements().forEach(drgElement -> {
            HasVariable hasVariable;
            IsInformationItem variable;
            QName typeRef;
            String oldType;
            Id oldId = drgElement.getId();
            if (oldId.getValue().startsWith(oldModelName)) {
                String newId = oldId.getValue().replaceAll("^" + oldModelName, newModelName);
                drgElement.setId(new Id(newId));
            }
            if (drgElement instanceof HasVariable && (oldType = (typeRef = (variable = (hasVariable = (HasVariable)drgElement).getVariable()).getTypeRef()).getLocalPart()).startsWith(oldModelName)) {
                String newType = oldType.replaceAll("^" + oldModelName, newModelName);
                variable.setTypeRef(new QName(typeRef.getNamespaceURI(), newType, typeRef.getPrefix()));
            }
        });
    }

    private boolean drgElementNameStartsWith(String oldModelName, DRGElement drgElement) {
        String value = drgElement.getName().getValue();
        return value.startsWith(oldModelName + ".");
    }

    void deleteDRGElement(DRGElement drgElement) {
        this.sessionCommandManager.execute((Object)this.getCanvasHandler(), this.buildDeleteCommand(drgElement));
    }

    CompositeCommand<AbstractCanvasHandler, CanvasViolation> buildDeleteCommand(DRGElement drgElement) {
        CompositeCommand.Builder commandBuilder = new CompositeCommand.Builder();
        Node node = this.getNode(drgElement);
        commandBuilder.addCommand((Command)this.canvasCommandFactory.deleteNode(node));
        return commandBuilder.build();
    }

    void updateDRGElementName(DRGElement drgElement, String newName) {
        this.sessionCommandManager.execute((Object)this.getCanvasHandler(), this.buildUpdateCommand(drgElement, newName));
    }

    CompositeCommand<AbstractCanvasHandler, CanvasViolation> buildUpdateCommand(DRGElement drgElement, String newName) {
        Definition definition;
        String nameId;
        CompositeCommand.Builder commandBuilder = new CompositeCommand.Builder();
        Node node = this.getNode(drgElement);
        if (node.getContent() instanceof Definition && (nameId = this.definitionUtils.getNameIdentifier((definition = (Definition)node.getContent()).getDefinition())) != null) {
            commandBuilder.addCommand((Command)this.canvasCommandFactory.updatePropertyValue((Element)node, nameId, newName));
        }
        return commandBuilder.build();
    }

    Node getNode(Object definition) {
        Graph graph = this.getCanvasHandler().getDiagram().getGraph();
        return StreamSupport.stream(graph.nodes().spliterator(), false).filter(node -> node.getContent() instanceof Definition).filter(node -> Objects.equals(definition, ((Definition)node.getContent()).getDefinition())).findFirst().orElse(null);
    }

    private AbstractCanvasHandler getCanvasHandler() {
        return (AbstractCanvasHandler)this.dmnGraphUtils.getCanvasHandler();
    }
}

