/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports.persistence;

import java.util.Map;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsPageStateProviderImpl;
import org.kie.workbench.common.dmn.client.graph.DMNGraphUtils;

public class DefinitionsHandler {
    private final IncludedModelsPageStateProviderImpl stateProvider;
    private final DMNGraphUtils dmnGraphUtils;

    @Inject
    public DefinitionsHandler(IncludedModelsPageStateProviderImpl stateProvider, DMNGraphUtils dmnGraphUtils) {
        this.stateProvider = stateProvider;
        this.dmnGraphUtils = dmnGraphUtils;
    }

    public void update(String oldModelName, IncludedModel includedModel) {
        this.getNsContext().remove(oldModelName);
        this.getNsContext().put(includedModel.getName(), includedModel.getNamespace());
    }

    public void destroy(IncludedModel includedModel) {
        this.getNsContext().remove(includedModel.getName());
    }

    public void create(IncludedModel includedModel) {
        this.getNsContext().put(includedModel.getName(), includedModel.getNamespace());
    }

    private Map<String, String> getNsContext() {
        return this.stateProvider.getDiagram().map(this.dmnGraphUtils::getDefinitions).map(DMNModelInstrumentedBase::getNsContext).orElseThrow(UnsupportedOperationException::new);
    }
}

