/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports.persistence;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.Import;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.kie.workbench.common.dmn.client.editors.common.persistence.RecordEngine;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.client.editors.included.imports.ImportFactory;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsIndex;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsPageStateProviderImpl;
import org.kie.workbench.common.dmn.client.editors.included.imports.messages.IncludedModelErrorMessageFactory;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.DRGElementHandler;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.DefinitionsHandler;
import org.kie.workbench.common.dmn.client.editors.included.imports.persistence.ItemDefinitionHandler;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class ImportRecordEngine
implements RecordEngine<IncludedModel> {
    private final IncludedModelsPageStateProviderImpl stateProvider;
    private final IncludedModelsIndex includedModelsIndex;
    private final IncludedModelErrorMessageFactory messageFactory;
    private final ImportFactory importFactory;
    private final Event<FlashMessage> flashMessageEvent;
    private final DefinitionsHandler definitionsHandler;
    private final ItemDefinitionHandler itemDefinitionHandler;
    private final DRGElementHandler drgElementHandler;

    @Inject
    public ImportRecordEngine(IncludedModelsPageStateProviderImpl stateProvider, IncludedModelsIndex includedModelsIndex, IncludedModelErrorMessageFactory messageFactory, ImportFactory importFactory, Event<FlashMessage> flashMessageEvent, DefinitionsHandler definitionsHandler, ItemDefinitionHandler itemDefinitionHandler, DRGElementHandler drgElementHandler) {
        this.stateProvider = stateProvider;
        this.includedModelsIndex = includedModelsIndex;
        this.messageFactory = messageFactory;
        this.importFactory = importFactory;
        this.flashMessageEvent = flashMessageEvent;
        this.definitionsHandler = definitionsHandler;
        this.itemDefinitionHandler = itemDefinitionHandler;
        this.drgElementHandler = drgElementHandler;
    }

    @Override
    public List<IncludedModel> update(IncludedModel record) {
        if (!record.isValid()) {
            throw new UnsupportedOperationException("An invalid Included Model cannot be updated.");
        }
        Import anImport = this.getImport(record);
        String oldModelName = anImport.getName().getValue();
        this.definitionsHandler.update(oldModelName, record);
        this.itemDefinitionHandler.update(oldModelName, record.getName());
        this.drgElementHandler.update(oldModelName, record.getName());
        anImport.setName(new Name(record.getName()));
        return Collections.singletonList(record);
    }

    @Override
    public List<IncludedModel> destroy(IncludedModel record) {
        this.definitionsHandler.destroy(record);
        this.itemDefinitionHandler.destroy(record.getName());
        this.drgElementHandler.destroy(record.getName());
        this.stateProvider.getImports().remove(this.getImport(record));
        return Collections.singletonList(record);
    }

    @Override
    public List<IncludedModel> create(IncludedModel record) {
        this.definitionsHandler.create(record);
        this.stateProvider.getImports().add(this.importFactory.makeImport(record));
        return Collections.singletonList(record);
    }

    @Override
    public boolean isValid(IncludedModel record) {
        if (!this.isUniqueName(record)) {
            this.flashMessageEvent.fire((Object)this.messageFactory.getNameIsNotUniqueFlashMessage(record));
            return false;
        }
        if (this.isBlankName(record)) {
            this.flashMessageEvent.fire((Object)this.messageFactory.getNameIsBlankFlashMessage(record));
            return false;
        }
        return true;
    }

    private boolean isUniqueName(IncludedModel record) {
        return this.stateProvider.getImports().stream().noneMatch(anImport -> !this.sameImport(record, (Import)anImport) && this.sameName(record, (Import)anImport));
    }

    private boolean isBlankName(IncludedModel record) {
        return StringUtils.isEmpty((String)record.getName());
    }

    private boolean sameName(IncludedModel record, Import anImport) {
        return Objects.equals(record.getName(), anImport.getName().getValue());
    }

    private boolean sameImport(IncludedModel record, Import anImport) {
        Import recordImport = this.getImport(record);
        return Objects.equals(recordImport, anImport);
    }

    private Import getImport(IncludedModel record) {
        return this.includedModelsIndex.getImport(record);
    }
}

