/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.imports.persistence;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.NamedElement;
import org.kie.workbench.common.dmn.api.property.dmn.Name;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.common.ItemDefinitionUtils;
import org.kie.workbench.common.dmn.client.editors.types.common.events.RefreshDataTypesListEvent;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.common.PropertiesPanelNotifier;

public class ItemDefinitionHandler {
    private final ItemDefinitionUtils itemDefinitionUtils;
    private final Event<RefreshDataTypesListEvent> refreshDataTypesListEvent;
    private final PropertiesPanelNotifier panelNotifier;

    @Inject
    public ItemDefinitionHandler(ItemDefinitionUtils itemDefinitionUtils, Event<RefreshDataTypesListEvent> refreshDataTypesListEvent, PropertiesPanelNotifier panelNotifier) {
        this.itemDefinitionUtils = itemDefinitionUtils;
        this.refreshDataTypesListEvent = refreshDataTypesListEvent;
        this.panelNotifier = panelNotifier;
    }

    public void update(String oldModelName, String newModelName) {
        List<ItemDefinition> updatedItemDefinitionsByName = this.findItemDefinitionsByOldName(oldModelName);
        List<ItemDefinition> updatedItemDefinitionsByType = this.findItemDefinitionsByUpdatedItemDefinitions(updatedItemDefinitionsByName);
        updatedItemDefinitionsByName.forEach(itemDefinition -> {
            String oldName = itemDefinition.getName().getValue();
            String newName = oldName.replaceAll("^" + oldModelName, newModelName);
            Name name = new Name(newName);
            itemDefinition.setName(name);
            this.notifyPropertiesPanel(oldName, newName);
        });
        updatedItemDefinitionsByType.forEach(itemDefinition -> {
            QName oldType = itemDefinition.getTypeRef();
            String newLocalPart = oldType.getLocalPart().replaceAll("^" + oldModelName, newModelName);
            QName qName = new QName(oldType.getNamespaceURI(), newLocalPart, oldType.getPrefix());
            itemDefinition.setTypeRef(qName);
        });
        this.refreshDataTypesList();
    }

    public void destroy(String oldModelName) {
        List<ItemDefinition> updatedItemDefinitionsByName = this.findItemDefinitionsByOldName(oldModelName);
        List<ItemDefinition> updatedItemDefinitionsByType = this.findItemDefinitionsByUpdatedItemDefinitions(updatedItemDefinitionsByName);
        this.itemDefinitionUtils.all().removeIf(itemDefinition -> updatedItemDefinitionsByName.contains(itemDefinition) || updatedItemDefinitionsByType.contains(itemDefinition));
        this.refreshDataTypesList();
    }

    private QName makeQName(String value) {
        return new QName("", value);
    }

    private QName normaliseTypeRef(QName typeRef) {
        return this.itemDefinitionUtils.normaliseTypeRef(typeRef);
    }

    void notifyPropertiesPanel(String oldLocalPart, String newLocalPart) {
        this.panelNotifier.withOldLocalPart(oldLocalPart).withNewQName(this.normaliseTypeRef(this.makeQName(newLocalPart))).notifyPanel();
    }

    private List<ItemDefinition> findItemDefinitionsByOldName(String oldModelName) {
        return this.itemDefinitionUtils.all().stream().filter(itemDefinition -> this.itemDefinitionNameStartsWith(oldModelName, (ItemDefinition)itemDefinition)).filter(ItemDefinition::isAllowOnlyVisualChange).collect(Collectors.toList());
    }

    private List<ItemDefinition> findItemDefinitionsByUpdatedItemDefinitions(List<ItemDefinition> updatedItemDefinitions) {
        List<String> updatedTypes = this.collectNames(updatedItemDefinitions);
        return this.itemDefinitionUtils.all().stream().filter(itemDefinition -> this.isItemDefinitionUpdatedType((ItemDefinition)itemDefinition, updatedTypes)).collect(Collectors.toList());
    }

    private boolean isItemDefinitionUpdatedType(ItemDefinition itemDefinition, List<String> updatedTypes) {
        if (Objects.isNull(itemDefinition.getTypeRef())) {
            return false;
        }
        return updatedTypes.contains(itemDefinition.getTypeRef().getLocalPart());
    }

    private boolean itemDefinitionNameStartsWith(String oldModelName, ItemDefinition itemDefinition) {
        return itemDefinition.getName().getValue().startsWith(oldModelName + ".");
    }

    private List<String> collectNames(List<ItemDefinition> updatedItemDefinitions) {
        return updatedItemDefinitions.stream().map(NamedElement::getName).map(Name::getValue).collect(Collectors.toList());
    }

    private void refreshDataTypesList() {
        this.refreshDataTypesListEvent.fire((Object)new RefreshDataTypesListEvent());
    }
}

