/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.included.modal.dropdown;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.client.api.included.legacy.DMNIncludeModelsClient;
import org.kie.workbench.common.dmn.client.editors.included.IncludedModelsPageState;
import org.kie.workbench.common.dmn.client.editors.included.imports.IncludedModelsIndex;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItem;
import org.kie.workbench.common.widgets.client.assets.dropdown.KieAssetsDropdownItemsProvider;

@Dependent
public class DMNAssetsDropdownItemsProvider
implements KieAssetsDropdownItemsProvider {
    public static final String PATH_METADATA = "path";
    public static final String DRG_ELEMENT_COUNT_METADATA = "drg_element_count";
    public static final String ITEM_DEFINITION_COUNT_METADATA = "item_definition_count";
    private final DMNIncludeModelsClient client;
    private final IncludedModelsPageState pageState;
    private final IncludedModelsIndex modelsIndex;

    @Inject
    public DMNAssetsDropdownItemsProvider(DMNIncludeModelsClient client, IncludedModelsPageState pageState, IncludedModelsIndex modelsIndex) {
        this.client = client;
        this.pageState = pageState;
        this.modelsIndex = modelsIndex;
    }

    public void getItems(Consumer<List<KieAssetsDropdownItem>> assetListConsumer) {
        this.client.loadModels(this.wrap(assetListConsumer));
    }

    Consumer<List<DMNIncludedModel>> wrap(Consumer<List<KieAssetsDropdownItem>> assetListConsumer) {
        return dmnIncludeModels -> assetListConsumer.accept(dmnIncludeModels.stream().filter(this::isNotExisting).filter(this::isNotCurrentDiagram).map(this::asKieAsset).collect(Collectors.toList()));
    }

    private boolean isNotExisting(DMNIncludedModel data) {
        return this.modelsIndex.getIndexedImports().stream().noneMatch(anImport -> Objects.equals(data.getNamespace(), anImport.getNamespace()));
    }

    private boolean isNotCurrentDiagram(DMNIncludedModel data) {
        return !Objects.equals(data.getNamespace(), this.pageState.getCurrentDiagramNamespace());
    }

    KieAssetsDropdownItem asKieAsset(DMNIncludedModel dmnIncludedModel) {
        String text = dmnIncludedModel.getModelName();
        String subText = dmnIncludedModel.getModelPackage();
        String value = dmnIncludedModel.getNamespace();
        Map<String, String> metaData = this.buildMetaData(dmnIncludedModel);
        return new KieAssetsDropdownItem(text, subText, value, metaData);
    }

    private Map<String, String> buildMetaData(DMNIncludedModel dmnIncludedModel) {
        return new Maps.Builder().put((Object)PATH_METADATA, (Object)dmnIncludedModel.getPath()).put((Object)DRG_ELEMENT_COUNT_METADATA, (Object)dmnIncludedModel.getDrgElementsCount().toString()).put((Object)ITEM_DEFINITION_COUNT_METADATA, (Object)dmnIncludedModel.getItemDefinitionsCount().toString()).build();
    }
}

