/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.Div;
import org.jboss.errai.common.client.dom.Input;
import org.jboss.errai.common.client.dom.Span;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePageTabActiveEvent;
import org.kie.workbench.common.dmn.client.editors.types.DataTypePickerWidget;
import org.kie.workbench.common.dmn.client.editors.types.NameAndDataTypePopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.popover.AbstractPopoverViewImpl;
import org.uberfire.client.views.pfly.selectpicker.JQuerySelectPicker;
import org.uberfire.client.views.pfly.widgets.JQueryProducer;
import org.uberfire.client.views.pfly.widgets.Popover;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Templated
@ApplicationScoped
public class NameAndDataTypePopoverViewImpl
extends AbstractPopoverViewImpl
implements NameAndDataTypePopoverView {
    @DataField(value="nameEditor")
    private Input nameEditor;
    @DataField(value="typeRefSelector")
    private DataTypePickerWidget typeRefEditor;
    @DataField(value="nameLabel")
    private Span nameLabel;
    @DataField(value="dataTypeLabel")
    private Span dataTypeLabel;
    private NameAndDataTypePopoverView.Presenter presenter;
    private BootstrapSelectDropDownMonitor monitor;

    public NameAndDataTypePopoverViewImpl() {
    }

    @Inject
    public NameAndDataTypePopoverViewImpl(Input nameEditor, DataTypePickerWidget typeRefEditor, Div popoverElement, Div popoverContentElement, Span nameLabel, Span dataTypeLabel, JQueryProducer.JQuery<Popover> jQueryPopover, TranslationService translationService) {
        super(popoverElement, popoverContentElement, jQueryPopover);
        this.nameEditor = nameEditor;
        this.typeRefEditor = typeRefEditor;
        this.popoverElement = popoverElement;
        this.popoverContentElement = popoverContentElement;
        this.nameLabel = nameLabel;
        this.dataTypeLabel = dataTypeLabel;
        this.jQueryPopover = jQueryPopover;
        this.nameLabel.setTextContent(translationService.getTranslation("NameAndDataTypePopover.NameLabel"));
        this.dataTypeLabel.setTextContent(translationService.getTranslation("NameAndDataTypePopover.DataTypeLabel"));
        this.monitor = new BootstrapSelectDropDownMonitor((ParameterizedCommand<Optional<String>>)((ParameterizedCommand)editorTitle -> NameAndDataTypePopoverViewImpl.super.show(editorTitle)), () -> NameAndDataTypePopoverViewImpl.super.hide());
    }

    public void init(NameAndDataTypePopoverView.Presenter presenter) {
        this.presenter = presenter;
        this.typeRefEditor.addValueChangeHandler((ValueChangeHandler<QName>)((ValueChangeHandler)e -> presenter.setTypeRef((QName)e.getValue())));
    }

    @Override
    public void setDMNModel(DMNModelInstrumentedBase dmnModel) {
        this.typeRefEditor.setDMNModel(dmnModel);
    }

    @Override
    public void initName(String name) {
        this.nameEditor.setValue(name);
    }

    @Override
    public void initSelectedTypeRef(QName typeRef) {
        this.typeRefEditor.setValue(typeRef, false);
    }

    @Override
    public void show(Optional<String> editorTitle) {
        this.monitor.show(editorTitle);
    }

    @Override
    public void hide() {
        this.nameEditor.blur();
        this.monitor.hide();
    }

    @EventHandler(value={"nameEditor"})
    void onNameChange(BlurEvent event) {
        this.presenter.setName(this.nameEditor.getValue());
    }

    public void onDataTypePageNavTabActiveEvent(@Observes DataTypePageTabActiveEvent event) {
        this.hide();
    }

    static class BootstrapSelectDropDownMonitor {
        static final String SELECT_ID = "#kieDataType";
        static final String BOOTSTRAP_SELECT_SHOWN_EVENT = "shown.bs.select";
        static final String BOOTSTRAP_SELECT_HIDDEN_EVENT = "hidden.bs.select";
        boolean isSelectDropDownShown = false;
        private final ParameterizedCommand<Optional<String>> commandShow;
        private final Command commandHide;

        BootstrapSelectDropDownMonitor(ParameterizedCommand<Optional<String>> commandShow, Command commandHide) {
            this.commandShow = commandShow;
            this.commandHide = commandHide;
        }

        void show(Optional<String> editorTitle) {
            this.commandShow.execute(editorTitle);
            JQuerySelectPicker.$((String)SELECT_ID).on(BOOTSTRAP_SELECT_SHOWN_EVENT, event -> {
                this.isSelectDropDownShown = true;
            });
            JQuerySelectPicker.$((String)SELECT_ID).on(BOOTSTRAP_SELECT_HIDDEN_EVENT, event -> {
                this.isSelectDropDownShown = false;
            });
            this.isSelectDropDownShown = false;
        }

        void hide() {
            JQuerySelectPicker.$((String)SELECT_ID).off(BOOTSTRAP_SELECT_SHOWN_EVENT);
            if (this.isSelectDropDownShown) {
                JQuerySelectPicker.$((String)SELECT_ID).on(BOOTSTRAP_SELECT_HIDDEN_EVENT, event -> this.onHide());
            } else {
                this.onHide();
            }
        }

        void onHide() {
            JQuerySelectPicker.$((String)SELECT_ID).off(BOOTSTRAP_SELECT_HIDDEN_EVENT);
            this.commandHide.execute();
        }
    }
}

