/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import elemental2.dom.HTMLElement;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeUtils;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeListItem;
import org.uberfire.client.mvp.UberElemental;

@Dependent
public class DataTypeSelect {
    private final View view;
    private final DataTypeUtils dataTypeUtils;
    private final DataTypeManager dataTypeManager;
    private DataType dataType;
    private DataTypeListItem listItem;
    private List<DataType> subDataTypes;

    @Inject
    public DataTypeSelect(View view, DataTypeUtils dataTypeUtils, DataTypeManager dataTypeManager) {
        this.view = view;
        this.dataTypeUtils = dataTypeUtils;
        this.dataTypeManager = dataTypeManager;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void init(DataTypeListItem gridItem, DataType dataType) {
        this.listItem = gridItem;
        this.dataType = dataType;
        this.view.setDataType(dataType);
        this.subDataTypes = dataType.getSubDataTypes();
    }

    void refresh() {
        this.view.setupDropdown();
    }

    DataType getDataType() {
        return this.dataType;
    }

    void enableEditMode() {
        this.refresh();
        this.view.enableEditMode();
    }

    void disableEditMode() {
        this.view.disableEditMode();
    }

    List<DataType> getDefaultDataTypes() {
        return this.dataTypeUtils.defaultDataTypes();
    }

    List<DataType> getCustomDataTypes() {
        return this.dataTypeUtils.customDataTypes();
    }

    void refreshView(String typeName) {
        this.subDataTypes = this.dataTypeManager.from(this.getDataType()).makeExternalDataTypes(typeName);
        this.listItem.refreshSubItems(this.subDataTypes);
        this.listItem.refreshConstraintComponent();
    }

    public String getValue() {
        return this.view.getValue();
    }

    List<DataType> getSubDataTypes() {
        return this.subDataTypes;
    }

    public static interface View
    extends UberElemental<DataTypeSelect>,
    IsElement {
        public void setupDropdown();

        public void enableEditMode();

        public void disableEditMode();

        public void setDataType(DataType var1);

        public String getValue();
    }
}

