/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.ConstraintType;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.DataTypeConstraintComponent;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.DataTypeConstraintParserWarningEvent;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.DataTypeConstraintEnumeration;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.expression.DataTypeConstraintExpression;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.range.DataTypeConstraintRange;
import org.kie.workbench.common.dmn.client.editors.types.shortcuts.DataTypeShortcuts;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.ext.editor.commons.client.file.popups.elemental2.Elemental2Modal;
import org.uberfire.mvp.Command;

@Dependent
public class DataTypeConstraintModal
extends Elemental2Modal<View> {
    static final String WIDTH = "550px";
    static final String CONSTRAINT_INITIAL_VALUE = "";
    private final DataTypeConstraintEnumeration constraintEnumeration;
    private final DataTypeConstraintExpression constraintExpression;
    private final DataTypeConstraintRange constraintRange;
    private final DataTypeShortcuts dataTypeShortcuts;
    private DataTypeConstraintComponent currentComponent = DataTypeConstraintComponent.NONE;
    private String constraintValue = "";
    private ConstraintType constraintType = ConstraintType.NONE;
    private BiConsumer<String, ConstraintType> onSave;
    private String constraintValueType = "";

    @Inject
    public DataTypeConstraintModal(View view, DataTypeShortcuts dataTypeShortcuts, DataTypeConstraintEnumeration constraintEnumeration, DataTypeConstraintExpression constraintExpression, DataTypeConstraintRange constraintRange) {
        super((Elemental2Modal.View)view);
        this.dataTypeShortcuts = dataTypeShortcuts;
        this.constraintEnumeration = constraintEnumeration;
        this.constraintExpression = constraintExpression;
        this.constraintRange = constraintRange;
    }

    @PostConstruct
    public void setup() {
        this.superSetup();
        this.setWidth(WIDTH);
        this.constraintRange.setModal(this);
        ((View)this.getView()).init((Object)this);
    }

    public void save() {
        this.doSave(this.getComponentConstraintValue());
    }

    void clearAll() {
        this.constraintType = null;
        this.doSave(CONSTRAINT_INITIAL_VALUE);
    }

    void doSave(String value) {
        this.constraintValue = value;
        this.getOnSave().accept(value, this.constraintType);
        this.hide();
    }

    void load(String type, String value, ConstraintType constraintType) {
        this.constraintValue = value;
        this.constraintValueType = type;
        this.constraintType = !StringUtils.isEmpty((String)value) && this.isNone(constraintType) ? this.inferComponentType(value) : constraintType;
        this.prepareView();
    }

    void setupComponent(ConstraintType type) {
        this.constraintType = this.isNone(type) ? this.inferComponentType(this.getConstraintValue()) : type;
        this.currentComponent = this.getComponentByType(this.getConstraintType());
        this.currentComponent.setValue(this.getConstraintValue());
        this.currentComponent.setConstraintValueType(this.getConstraintValueType());
        this.currentComponent.getElement().setAttribute("class", this.componentCssClass());
        if (this.constraintType != ConstraintType.RANGE) {
            this.enableOkButton();
        }
    }

    private String componentCssClass() {
        return this.asCssClass(this.getConstraintValueType());
    }

    private String asCssClass(String type) {
        return "kie-" + type.replaceAll(" ", "-").toLowerCase();
    }

    boolean isNone(ConstraintType type) {
        return type == null || Objects.equals(type, ConstraintType.NONE);
    }

    private String getComponentConstraintValue() {
        return this.getCurrentComponent().getValue();
    }

    private DataTypeConstraintComponent getComponentByType(ConstraintType constraintType) {
        switch (constraintType) {
            case ENUMERATION: {
                return this.getConstraintEnumeration();
            }
            case EXPRESSION: {
                return this.getConstraintExpression();
            }
            case RANGE: {
                return this.getConstraintRange();
            }
        }
        throw new UnsupportedOperationException("The type '" + constraintType + "' is not a valid component.");
    }

    void prepareView() {
        ((View)this.getView()).setType(this.getConstraintValueType());
        if (!StringUtils.isEmpty((String)this.getConstraintValue()) || !this.isNone(this.getConstraintType())) {
            ((View)this.getView()).loadComponent(this.getConstraintType());
        } else {
            ((View)this.getView()).setupEmptyContainer();
        }
    }

    void setConstraintType(ConstraintType constraintType) {
        this.constraintType = constraintType;
    }

    ConstraintType inferComponentType(String constraintValue) {
        String value = Optional.ofNullable(constraintValue).orElse(CONSTRAINT_INITIAL_VALUE);
        if (this.isRange(value)) {
            return ConstraintType.RANGE;
        }
        if (this.isEnumeration(value)) {
            return ConstraintType.ENUMERATION;
        }
        return ConstraintType.EXPRESSION;
    }

    private boolean isEnumeration(String constraintValue) {
        return !constraintValue.startsWith("(") && !constraintValue.startsWith("[") && !constraintValue.endsWith("]") && !constraintValue.endsWith(")") && constraintValue.contains(",");
    }

    private boolean isRange(String constraintValue) {
        int countMatches = constraintValue.split("(\\.\\.)", -1).length - 1;
        return countMatches == 1;
    }

    public void show(BiConsumer<String, ConstraintType> onSaveConsumer) {
        this.onSave = onSaveConsumer;
        this.superShow();
        ((View)this.getView()).onShow();
        ((View)this.getView()).setupOnHideHandler(this::onHide);
        this.dataTypeShortcuts.disable();
    }

    public void hide() {
        this.superHide();
        this.onHide();
    }

    void onHide() {
        this.dataTypeShortcuts.enable();
    }

    void superShow() {
        super.show();
    }

    void superHide() {
        super.hide();
    }

    void onDataTypeConstraintParserWarningEvent(@Observes DataTypeConstraintParserWarningEvent e) {
        ((View)this.getView()).showConstraintWarningMessage();
    }

    private DataTypeConstraintEnumeration getConstraintEnumeration() {
        return this.constraintEnumeration;
    }

    private DataTypeConstraintExpression getConstraintExpression() {
        return this.constraintExpression;
    }

    private DataTypeConstraintRange getConstraintRange() {
        return this.constraintRange;
    }

    BiConsumer<String, ConstraintType> getOnSave() {
        return this.onSave;
    }

    protected void setWidth(String width) {
        super.setWidth(width);
    }

    public void enableOkButton() {
        ((View)this.getView()).enableOkButton();
    }

    public void disableOkButton() {
        ((View)this.getView()).disableOkButton();
    }

    DataTypeConstraintComponent getCurrentComponent() {
        return this.currentComponent;
    }

    String getConstraintValue() {
        return this.constraintValue;
    }

    String getConstraintValueType() {
        return this.constraintValueType;
    }

    ConstraintType getConstraintType() {
        return this.constraintType;
    }

    public static interface View
    extends Elemental2Modal.View<DataTypeConstraintModal> {
        public void setType(String var1);

        public void setupEmptyContainer();

        public void loadComponent(ConstraintType var1);

        public void onShow();

        public void showConstraintWarningMessage();

        public void setupOnHideHandler(Command var1);

        public void enableOkButton();

        public void disableOkButton();
    }
}

