/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed;

import java.util.Objects;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.TypedValueSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.DateSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.day.time.DayTimeSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.generic.GenericSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.number.NumberSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.string.StringSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.TimeSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.years.months.YearsMonthsSelector;

@Dependent
public class TypedValueComponentSelector {
    private final GenericSelector genericSelector;
    private final DateSelector dateSelector;
    private final DayTimeSelector dayTimeSelector;
    private final YearsMonthsSelector yearsMosSelector;
    private final TimeSelector timeSelector;
    private final StringSelector stringSelector;
    private final NumberSelector numberSelector;

    @Inject
    public TypedValueComponentSelector(GenericSelector genericSelector, DateSelector dateSelector, DayTimeSelector dayTimeSelector, YearsMonthsSelector yearsMosSelector, StringSelector stringSelector, NumberSelector numberSelector, TimeSelector timeSelector) {
        this.genericSelector = genericSelector;
        this.dateSelector = dateSelector;
        this.dayTimeSelector = dayTimeSelector;
        this.yearsMosSelector = yearsMosSelector;
        this.stringSelector = stringSelector;
        this.numberSelector = numberSelector;
        this.timeSelector = timeSelector;
    }

    public TypedValueSelector makeSelectorForType(String type) {
        if (this.isEqual(type, BuiltInType.DATE)) {
            return this.dateSelector;
        }
        if (this.isEqual(type, BuiltInType.DURATION_DAYS_TIME)) {
            return this.dayTimeSelector;
        }
        if (this.isEqual(type, BuiltInType.DURATION_YEAR_MONTH)) {
            return this.yearsMosSelector;
        }
        if (this.isEqual(type, BuiltInType.STRING)) {
            return this.stringSelector;
        }
        if (this.isEqual(type, BuiltInType.NUMBER)) {
            return this.numberSelector;
        }
        if (this.isEqual(type, BuiltInType.TIME)) {
            return this.timeSelector;
        }
        return this.genericSelector;
    }

    private boolean isEqual(String type, BuiltInType builtInType) {
        return Objects.equals(builtInType.getName(), type);
    }
}

