/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.common;

import elemental2.dom.HTMLInputElement;

public class MinMaxValueHelper {
    static final String OLD_ATTR = "data-old";

    public static void setupMinMaxHandlers(HTMLInputElement input) {
        input.onfocusout = e -> MinMaxValueHelper.onFocusOut(input);
        input.onkeydown = e -> MinMaxValueHelper.onKeyDown(input);
        input.onkeyup = e -> MinMaxValueHelper.onKeyUp(input);
    }

    private static boolean onKeyDown(HTMLInputElement input) {
        String inputValue = input.value;
        if (MinMaxValueHelper.isValidValue(input, MinMaxValueHelper.toNonNullInt(inputValue))) {
            MinMaxValueHelper.setOldAttribute(input, inputValue);
        }
        return true;
    }

    private static boolean onKeyUp(HTMLInputElement input) {
        String oldValue = MinMaxValueHelper.getOldAttribute(input);
        int newValue = MinMaxValueHelper.toNonNullInt(input.value);
        if (!MinMaxValueHelper.isValidValue(input, newValue)) {
            input.value = oldValue;
        }
        return true;
    }

    private static boolean onFocusOut(HTMLInputElement input) {
        return MinMaxValueHelper.onKeyUp(input);
    }

    static boolean isValidValue(HTMLInputElement input, int inputValue) {
        int max = MinMaxValueHelper.toInteger(input.max, Integer.MAX_VALUE);
        int min = MinMaxValueHelper.toInteger(input.min, Integer.MIN_VALUE);
        return inputValue >= min && inputValue <= max;
    }

    private static String getOldAttribute(HTMLInputElement input) {
        return input.getAttribute(OLD_ATTR);
    }

    private static void setOldAttribute(HTMLInputElement input, String value) {
        input.setAttribute(OLD_ATTR, value);
    }

    public static Integer toInteger(String value, Integer defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static int toNonNullInt(String value) {
        return MinMaxValueHelper.toInteger(value, 0);
    }
}

