/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.HTMLInputElement;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.DateSelector;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.DateValueFormatter;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.JQueryDatepicker;
import org.kie.workbench.common.stunner.core.util.StringUtils;

@Templated
@Dependent
public class DateSelectorView
implements DateSelector.View {
    @DataField(value="date-input")
    private final HTMLInputElement dateInput;
    private final DateValueFormatter valueFormatter;
    private DateSelectorView presenter;
    private Consumer<BlurEvent> onValueInputBlur;

    @Inject
    public DateSelectorView(HTMLInputElement dateInput, DateValueFormatter valueFormatter) {
        this.dateInput = dateInput;
        this.valueFormatter = valueFormatter;
    }

    @PostConstruct
    void init() {
        JQueryDatepicker.$((Element)this.dateInput).datepicker(this.properties().getJavaScriptObject());
    }

    JSONObject properties() {
        JSONObject jsonObject = this.makeJsonObject();
        jsonObject.put("format", (JSONValue)new JSONString("d M yyyy"));
        return jsonObject;
    }

    JSONObject makeJsonObject() {
        return new JSONObject();
    }

    @Override
    public String getValue() {
        return this.valueFormatter.toRaw(this.dateInput.value);
    }

    @Override
    public void setValue(String value) {
        if (StringUtils.isEmpty((String)value)) {
            this.dateInput.value = "";
        } else {
            JQueryDatepicker.$((Element)this.dateInput).datepicker("setDate", this.valueFormatter.toDisplay(value));
        }
    }

    @Override
    public void setPlaceholder(String placeholder) {
        this.dateInput.setAttribute("placeholder", placeholder);
    }

    @Override
    public void onValueChanged(Consumer<Event> onValueChanged) {
        this.dateInput.onchange = event -> {
            onValueChanged.accept(event);
            return this;
        };
    }

    @Override
    public void select() {
        this.dateInput.select();
    }

    @EventHandler(value={"date-input"})
    public void onDateInputBlur(BlurEvent blurEvent) {
        Object target = this.getEventTarget(blurEvent);
        if (!Objects.isNull(this.onValueInputBlur) && !Objects.isNull(target)) {
            this.onValueInputBlur.accept(blurEvent);
        }
    }

    Object getEventTarget(BlurEvent blurEvent) {
        return blurEvent.getNativeEvent().getRelatedEventTarget();
    }

    @Override
    public void onValueInputBlur(Consumer<BlurEvent> blurEvent) {
        this.onValueInputBlur = blurEvent;
    }

    public void init(DateSelectorView presenter) {
        this.presenter = presenter;
    }
}

