/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker;

import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimeValue;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimeZoneProvider;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class TimeValueFormatter {
    static final String PREFIX = "time(\"";
    static final String SUFFIX = "\")";
    static final String UTC = "UTC";
    private final TimeZoneProvider timeZoneProvider;

    @Inject
    public TimeValueFormatter(TimeZoneProvider timeZoneProvider) {
        this.timeZoneProvider = timeZoneProvider;
    }

    public String toDisplay(String input) {
        String timeString = this.removePrefixAndSuffix(input);
        return this.formatTime(timeString);
    }

    public String buildRawValue(String time, String selectedTimeZone) {
        String rawValue = StringUtils.isEmpty((String)selectedTimeZone) ? (StringUtils.isEmpty((String)time) ? "" : this.appendPrefixAndSuffix(time)) : (UTC.equals(selectedTimeZone) ? this.appendPrefixAndSuffix(time + "Z") : (selectedTimeZone.startsWith("+") || selectedTimeZone.startsWith("-") ? this.appendPrefixAndSuffix(time + selectedTimeZone) : this.appendPrefixAndSuffix(time + "@" + selectedTimeZone)));
        return rawValue;
    }

    String removePrefixAndSuffix(String value) {
        return value.replace(PREFIX, "").replace(SUFFIX, "");
    }

    String formatTime(String value) {
        TimeValue timeValue = this.getTimeValue(value);
        switch (timeValue.getTimeZoneMode()) {
            case OFFSET: {
                return timeValue.getTime() + " UTC " + timeValue.getTimeZoneValue();
            }
            case TIMEZONE: {
                return timeValue.getTime() + " " + timeValue.getTimeZoneValue();
            }
        }
        return timeValue.getTime();
    }

    public TimeValue getTimeValue(String val) {
        String value = this.removePrefixAndSuffix(val);
        TimeValue timeValue = new TimeValue();
        if (value.contains("@")) {
            String[] parts = value.split("@");
            timeValue.setTime(parts[0].trim());
            timeValue.setTimeZoneValue(parts[1].trim());
            timeValue.setTimeZoneMode(TimeValue.TimeZoneMode.TIMEZONE);
            return timeValue;
        }
        if (value.contains("-")) {
            String[] parts = value.split("-");
            timeValue.setTime(parts[0].trim());
            timeValue.setTimeZoneValue("-" + parts[1].trim());
            timeValue.setTimeZoneMode(TimeValue.TimeZoneMode.OFFSET);
            return timeValue;
        }
        if (value.contains("+")) {
            String[] parts = value.split("\\+");
            timeValue.setTime(parts[0].trim());
            timeValue.setTimeZoneValue("+" + parts[1].trim());
            timeValue.setTimeZoneMode(TimeValue.TimeZoneMode.OFFSET);
            return timeValue;
        }
        if (value.endsWith("Z")) {
            String timePart = value.replace("Z", "");
            timeValue.setTime(timePart);
            timeValue.setTimeZoneValue(UTC);
            timeValue.setTimeZoneMode(TimeValue.TimeZoneMode.TIMEZONE);
            return timeValue;
        }
        timeValue.setTimeZoneValue("");
        timeValue.setTimeZoneMode(TimeValue.TimeZoneMode.NONE);
        timeValue.setTime(value);
        return timeValue;
    }

    public String toRaw(String input) {
        if (!input.contains(" ")) {
            return this.appendPrefixAndSuffix(input);
        }
        String[] parts = input.split(" ");
        if (parts.length == 2) {
            String secondPart = parts[1].trim();
            if (this.timeZoneProvider.isTimeZone(secondPart)) {
                return this.appendPrefixAndSuffix(parts[0].trim() + "@" + secondPart);
            }
            return this.appendPrefixAndSuffix(parts[0].trim() + "Z");
        }
        String time = parts[0].trim();
        String offSet = parts[2].trim();
        return this.appendPrefixAndSuffix(time + offSet);
    }

    private String appendPrefixAndSuffix(String input) {
        return PREFIX + input + SUFFIX;
    }
}

