/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.dmn.api.editors.types.DMNSimpleTimeZone;
import org.kie.workbench.common.dmn.api.editors.types.TimeZoneService;

@ApplicationScoped
public class TimeZoneProvider {
    private final Caller<TimeZoneService> service;
    private final List<DMNSimpleTimeZone> timeZones;
    private final List<String> timeZonesOffsets;

    @Inject
    public TimeZoneProvider(Caller<TimeZoneService> service) {
        this.service = service;
        this.timeZones = new ArrayList<DMNSimpleTimeZone>();
        this.timeZonesOffsets = new ArrayList<String>();
    }

    public void getTimeZones(RemoteCallback<List<DMNSimpleTimeZone>> successCallback) {
        if (this.getLoadedTimeZones().isEmpty()) {
            ((TimeZoneService)this.service.call(timeZones -> {
                this.getLoadedTimeZones().clear();
                this.getLoadedTimeZones().addAll((Collection<DMNSimpleTimeZone>)timeZones);
                DMNSimpleTimeZone[] offSets = (DMNSimpleTimeZone[])timeZones.stream().sorted(Comparator.comparingDouble(DMNSimpleTimeZone::getOffset)).toArray(DMNSimpleTimeZone[]::new);
                this.getTimeZonesOffsets().clear();
                for (DMNSimpleTimeZone offSet : offSets) {
                    String offsetString = offSet.getOffsetString();
                    if (this.getTimeZonesOffsets().contains(offsetString)) continue;
                    this.getTimeZonesOffsets().add(offsetString);
                }
                successCallback.callback(timeZones);
            })).getTimeZones();
        } else {
            successCallback.callback(this.getLoadedTimeZones());
        }
    }

    public boolean isTimeZone(String timeZone) {
        if ("UTC".equals(timeZone)) {
            return false;
        }
        return this.getLoadedTimeZones().stream().anyMatch(s -> s.getId().equals(timeZone));
    }

    public List<String> getTimeZonesOffsets() {
        return this.timeZonesOffsets;
    }

    List<DMNSimpleTimeZone> getLoadedTimeZones() {
        return this.timeZones;
    }
}

