/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.validation;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.dmn.api.editors.types.DMNValidationService;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.errors.DataTypeNameIsInvalidErrorMessage;
import org.uberfire.mvp.Command;

@Dependent
public class DataTypeNameFormatValidator {
    private final Caller<DMNValidationService> service;
    private final Event<FlashMessage> flashMessageEvent;
    private final DataTypeNameIsInvalidErrorMessage nameIsInvalidErrorMessage;

    @Inject
    public DataTypeNameFormatValidator(Caller<DMNValidationService> service, Event<FlashMessage> flashMessageEvent, DataTypeNameIsInvalidErrorMessage nameIsInvalidErrorMessage) {
        this.service = service;
        this.flashMessageEvent = flashMessageEvent;
        this.nameIsInvalidErrorMessage = nameIsInvalidErrorMessage;
    }

    public void ifIsValid(DataType dataType, Command onSuccess) {
        RemoteCallback<Boolean> callback = this.getCallback(dataType, onSuccess);
        String dataTypeName = dataType.getName();
        ((DMNValidationService)this.service.call(callback)).isValidVariableName(dataTypeName);
    }

    RemoteCallback<Boolean> getCallback(DataType dataType, Command onSuccess) {
        return isValid -> {
            if (isValid.booleanValue()) {
                onSuccess.execute();
            } else {
                this.flashMessageEvent.fire((Object)this.nameIsInvalidErrorMessage.getFlashMessage(dataType));
            }
        };
    }
}

