/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.types.BuiltInTypeUtils;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.DataTypeHandler;

@Dependent
public class DataTypeUpdateHandler
extends DataTypeHandler {
    private final ItemDefinitionStore itemDefinitionStore;

    @Inject
    public DataTypeUpdateHandler(ItemDefinitionStore itemDefinitionStore, DataTypeStore dataTypeStore, DataTypeManager dataTypeManager) {
        super(dataTypeStore, dataTypeManager);
        this.itemDefinitionStore = itemDefinitionStore;
    }

    public void update(DataType dataType) {
        String type = dataType.getType();
        if (!BuiltInTypeUtils.isBuiltInType((String)type)) {
            this.dataTypeManager.from(dataType).withRefreshedSubDataTypes(type);
        }
    }

    public List<DataType> refreshDependentDataTypes(DataType dataType, String oldItemDefinitionName) {
        ArrayList<DataType> affectedDataTypes = new ArrayList<DataType>();
        affectedDataTypes.addAll(this.handleTopLevelDataTypeUpdate(dataType, oldItemDefinitionName));
        affectedDataTypes.addAll(this.handleNestedDataTypeFieldUpdate(dataType));
        return affectedDataTypes;
    }

    List<DataType> handleTopLevelDataTypeUpdate(DataType dataType, String oldItemDefinitionName) {
        return this.updateAllChildrenWithTheNewTypeName(dataType, oldItemDefinitionName);
    }

    List<DataType> handleNestedDataTypeFieldUpdate(DataType dataType) {
        ArrayList<DataType> affectedDataTypes = new ArrayList<DataType>();
        this.getClosestTopLevelDataType(dataType).ifPresent(topLevelUpdate -> {
            this.refreshSubDataTypes((DataType)topLevelUpdate, topLevelUpdate.getName());
            if (!this.isStructure((DataType)topLevelUpdate)) {
                this.forEachSubDataTypesByTypeOrName(topLevelUpdate.getType(), subDataType -> {
                    this.refreshSubDataTypes((DataType)subDataType, topLevelUpdate.getType());
                    affectedDataTypes.add((DataType)subDataType);
                });
            } else {
                affectedDataTypes.addAll(this.handleTopLevelDataTypeUpdate((DataType)topLevelUpdate, topLevelUpdate.getName()));
            }
            affectedDataTypes.add((DataType)topLevelUpdate);
        });
        return affectedDataTypes;
    }

    List<DataType> updateAllChildrenWithTheNewTypeName(DataType dataType, String oldTypeName) {
        ArrayList<DataType> affectedDataTypes = new ArrayList<DataType>();
        if (dataType.isTopLevel()) {
            this.refreshSubDataTypes(dataType);
            affectedDataTypes.addAll(this.forEachSubDataTypesByType(oldTypeName, subDataType -> this.refreshSubDataType((DataType)subDataType, dataType.getName())));
            affectedDataTypes.add(dataType);
        }
        return affectedDataTypes;
    }

    void refreshSubDataType(DataType dataType, String newType) {
        ItemDefinition itemDefinition = this.itemDefinitionStore.get(dataType.getUUID());
        this.dataTypeManager.from(dataType).withType(newType);
        this.recordEngine.doUpdate(dataType, itemDefinition);
        this.refreshSubDataTypes(dataType, dataType.getType());
    }
}

