/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.search;

import elemental2.dom.HTMLElement;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.search.DataTypeSearchEngine;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.client.mvp.UberElemental;

@ApplicationScoped
public class DataTypeSearchBar {
    private final View view;
    private final DataTypeSearchEngine searchEngine;
    private final DataTypeList dataTypeList;
    private String currentSearch;

    @Inject
    public DataTypeSearchBar(View view, DataTypeSearchEngine searchEngine, DataTypeList dataTypeList) {
        this.view = view;
        this.searchEngine = searchEngine;
        this.dataTypeList = dataTypeList;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    public void refresh() {
        this.search(this.getCurrentSearch());
    }

    public void reset() {
        this.setCurrentSearch("");
        this.dataTypeList.showListItems();
        this.view.resetSearchBar();
    }

    void search(String keyword) {
        List<DataType> results = this.searchEngine.search(keyword);
        this.showEmptyView(results.isEmpty());
        this.setCurrentSearch(keyword);
        if (StringUtils.isEmpty((String)keyword)) {
            this.reset();
        } else {
            this.view.showSearchResults(results);
        }
    }

    HTMLElement getResultsContainer() {
        return this.dataTypeList.getListItemsElement();
    }

    String getCurrentSearch() {
        return this.currentSearch;
    }

    void setCurrentSearch(String currentSearch) {
        this.currentSearch = currentSearch;
    }

    private void showEmptyView(boolean show) {
        if (show) {
            this.dataTypeList.showNoDataTypesFound();
        } else {
            this.dataTypeList.showListItems();
        }
    }

    public boolean isEnabled() {
        return !StringUtils.isEmpty((String)this.getCurrentSearch());
    }

    public static interface View
    extends UberElemental<DataTypeSearchBar>,
    IsElement {
        public void showSearchResults(List<DataType> var1);

        public void resetSearchBar();
    }
}

