/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.shortcuts;

import elemental2.dom.DomGlobal;
import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.EventListener;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.KeyboardEvent;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.shortcuts.DataTypeListShortcuts;
import org.uberfire.client.views.pfly.selectpicker.JQuery;

@ApplicationScoped
public class DataTypeShortcuts {
    private final DataTypeListShortcuts listShortcuts;
    EventListener KEY_DOWN_LISTENER = this::keyDownListener;
    EventListener CLICK_LISTENER = this::clickListener;
    private boolean loaded = false;
    private boolean enabled = true;

    @Inject
    public DataTypeShortcuts(DataTypeListShortcuts listShortcuts) {
        this.listShortcuts = listShortcuts;
    }

    public void init(DataTypeList dataTypeList) {
        this.listShortcuts.init(dataTypeList);
    }

    public void setup() {
        if (this.isLoaded()) {
            return;
        }
        this.loaded = true;
        this.addEventListener("keydown", this.KEY_DOWN_LISTENER);
        this.addEventListener("click", this.CLICK_LISTENER);
    }

    public void teardown() {
        if (!this.isLoaded()) {
            return;
        }
        this.loaded = false;
        this.removeEventListener("keydown", this.KEY_DOWN_LISTENER);
        this.removeEventListener("click", this.CLICK_LISTENER);
    }

    void clickListener(Event event) {
        if (this.isNotEnabled()) {
            return;
        }
        if (this.tabContentContainsTarget(event)) {
            this.listShortcuts.focusIn();
        } else {
            this.listShortcuts.reset();
        }
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    boolean isNotEnabled() {
        return !this.enabled;
    }

    void keyDownListener(Event e) {
        KeyboardEvent event = (KeyboardEvent)e;
        if (this.isNotEnabled()) {
            return;
        }
        switch (event.key) {
            case "Esc": 
            case "Escape": {
                this.listShortcuts.onEscape();
                return;
            }
            case "Backspace": {
                if (event.ctrlKey) {
                    this.listShortcuts.onCtrlBackspace();
                }
                return;
            }
            case "Tab": {
                if (this.isSearchBarTarget(event)) {
                    event.preventDefault();
                    this.listShortcuts.onTab();
                }
                return;
            }
            case "s": {
                if (event.ctrlKey) {
                    event.preventDefault();
                    this.listShortcuts.onCtrlS();
                }
                return;
            }
            case "b": {
                if (event.ctrlKey) {
                    event.preventDefault();
                    this.listShortcuts.onCtrlB();
                }
                return;
            }
            case "u": {
                if (event.ctrlKey) {
                    event.preventDefault();
                    this.listShortcuts.onCtrlU();
                }
                return;
            }
            case "d": {
                if (event.ctrlKey) {
                    event.preventDefault();
                    this.listShortcuts.onCtrlD();
                }
                return;
            }
            case "e": {
                if (event.ctrlKey) {
                    event.preventDefault();
                    this.listShortcuts.onCtrlE();
                }
                return;
            }
        }
        if (this.isInputEvent(event) && !this.isSearchBarTarget(event)) {
            return;
        }
        switch (event.key) {
            case "Down": 
            case "ArrowDown": {
                this.listShortcuts.onArrowDown();
                return;
            }
            case "Up": 
            case "ArrowUp": {
                this.listShortcuts.onArrowUp();
                return;
            }
            case "Left": 
            case "ArrowLeft": {
                this.listShortcuts.onArrowLeft();
                return;
            }
            case "Right": 
            case "ArrowRight": {
                this.listShortcuts.onArrowRight();
            }
        }
    }

    boolean isSearchBarTarget(KeyboardEvent event) {
        Element element = this.getTarget((Event)event);
        return Objects.equals(element.getAttribute("data-field"), "search-bar");
    }

    boolean isInputEvent(KeyboardEvent event) {
        return this.isTargetElementAnInput(event) || this.isDropdownOpened();
    }

    boolean isTargetElementAnInput(KeyboardEvent event) {
        Element element = this.getTarget((Event)event);
        return element instanceof HTMLInputElement;
    }

    private boolean tabContentContainsTarget(Event event) {
        Element target = this.getTarget(event);
        Element tabContent = this.getTabContent();
        return JQuery.$.contains(tabContent, target);
    }

    private Element getTabContent() {
        return this.querySelector(".tab-content");
    }

    boolean isDropdownOpened() {
        return this.querySelector(".bs-container.btn-group.bootstrap-select.open") != null;
    }

    boolean isLoaded() {
        return this.loaded;
    }

    Element querySelector(String selector) {
        return DomGlobal.document.querySelector(selector);
    }

    void addEventListener(String type, EventListener eventListener) {
        DomGlobal.document.addEventListener(type, eventListener);
    }

    void removeEventListener(String type, EventListener eventListener) {
        DomGlobal.document.removeEventListener(type, eventListener);
    }

    private Element getTarget(Event e) {
        return (Element)e.target;
    }
}

