/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.graph;

import java.util.List;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.v1_1.DRGElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.Definitions;
import org.kie.workbench.common.dmn.api.graph.DMNDiagramUtils;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;

@Dependent
public class DMNGraphUtils {
    private static Definitions NO_DEFINITIONS = null;
    private static Diagram NO_DIAGRAM = null;
    private static CanvasHandler NO_CANVAS_HANDLER = null;
    private SessionManager sessionManager;
    private DMNDiagramUtils dmnDiagramUtils;

    public DMNGraphUtils() {
    }

    @Inject
    public DMNGraphUtils(SessionManager sessionManager, DMNDiagramUtils dmnDiagramUtils) {
        this.sessionManager = sessionManager;
        this.dmnDiagramUtils = dmnDiagramUtils;
    }

    public Definitions getDefinitions() {
        return this.getCurrentSession().map(clientSession -> this.getCanvasHandler((ClientSession)clientSession).map(canvasHandler -> this.dmnDiagramUtils.getDefinitions(canvasHandler.getDiagram())).orElse(NO_DEFINITIONS)).orElse(NO_DEFINITIONS);
    }

    public Diagram getDiagram() {
        return this.getCurrentSession().map(clientSession -> this.getCanvasHandler((ClientSession)clientSession).map(CanvasHandler::getDiagram).orElse(NO_DIAGRAM)).orElse(NO_DIAGRAM);
    }

    public CanvasHandler getCanvasHandler() {
        return this.getCurrentSession().map(clientSession -> this.getCanvasHandler((ClientSession)clientSession).orElse(NO_CANVAS_HANDLER)).orElse(NO_CANVAS_HANDLER);
    }

    public Definitions getDefinitions(Diagram diagram) {
        return this.dmnDiagramUtils.getDefinitions(diagram);
    }

    public List<DRGElement> getDRGElements() {
        return this.dmnDiagramUtils.getNodes(this.getDiagram());
    }

    private Optional<ClientSession> getCurrentSession() {
        return Optional.ofNullable(this.sessionManager.getCurrentSession());
    }

    private Optional<CanvasHandler> getCanvasHandler(ClientSession session) {
        return Optional.ofNullable(session.getCanvasHandler());
    }
}

