/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.property.dmn;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.kie.workbench.common.dmn.api.definition.v1_1.BusinessKnowledgeModel;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.Decision;
import org.kie.workbench.common.dmn.api.definition.v1_1.DecisionService;
import org.kie.workbench.common.dmn.api.definition.v1_1.InputData;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeSource;
import org.kie.workbench.common.dmn.api.definition.v1_1.NamedElement;
import org.kie.workbench.common.dmn.api.definition.v1_1.TextAnnotation;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class DefaultValueUtilities {
    public static void updateNewNodeName(Graph<?, Node> graph, DMNModelInstrumentedBase dmnModel) {
        if (dmnModel instanceof NamedElement && DefaultValueUtilities.isNameAlreadySet((NamedElement)dmnModel)) {
            return;
        }
        if (dmnModel instanceof BusinessKnowledgeModel) {
            DefaultValueUtilities.updateBusinessKnowledgeModelDefaultName(graph, (BusinessKnowledgeModel)dmnModel);
        } else if (dmnModel instanceof Decision) {
            DefaultValueUtilities.updateDecisionDefaultName(graph, (Decision)dmnModel);
        } else if (dmnModel instanceof InputData) {
            DefaultValueUtilities.updateInputDataDefaultName(graph, (InputData)dmnModel);
        } else if (dmnModel instanceof KnowledgeSource) {
            DefaultValueUtilities.updateKnowledgeSourceDefaultName(graph, (KnowledgeSource)dmnModel);
        } else if (dmnModel instanceof TextAnnotation) {
            DefaultValueUtilities.updateTextAnnotationDefaultText(graph, (TextAnnotation)dmnModel);
        } else if (dmnModel instanceof DecisionService) {
            DefaultValueUtilities.updateDecisionServiceDefaultName(graph, (DecisionService)dmnModel);
        } else {
            throw new IllegalArgumentException("Default Name for '" + dmnModel.getClass().getSimpleName() + "' is not supported.");
        }
    }

    public static Optional<Integer> extractIndex(String text, String prefix) {
        if (text == null) {
            return Optional.empty();
        }
        if (!text.startsWith(prefix)) {
            return Optional.empty();
        }
        String suffix = text.substring(prefix.length());
        try {
            return Optional.of(Integer.parseInt(suffix));
        }
        catch (NumberFormatException nfe) {
            return Optional.empty();
        }
    }

    public static int getMaxUnusedIndex(Collection<String> values, String prefix) {
        int maxIndex = 0;
        for (String value : values) {
            Optional<Integer> index = DefaultValueUtilities.extractIndex(value, prefix);
            if (!index.isPresent()) continue;
            maxIndex = Math.max(maxIndex, index.get());
        }
        return maxIndex + 1;
    }

    private static void updateBusinessKnowledgeModelDefaultName(Graph<?, Node> graph, BusinessKnowledgeModel bkm) {
        String prefix = bkm.getClass().getSimpleName() + "-";
        bkm.getName().setValue(prefix + DefaultValueUtilities.getMaxUnusedIndex(DefaultValueUtilities.getExistingNodeNames(graph, bkm, n -> n.getName().getValue()), prefix));
    }

    private static void updateDecisionDefaultName(Graph<?, Node> graph, Decision decision) {
        String prefix = decision.getClass().getSimpleName() + "-";
        decision.getName().setValue(prefix + DefaultValueUtilities.getMaxUnusedIndex(DefaultValueUtilities.getExistingNodeNames(graph, decision, n -> n.getName().getValue()), prefix));
    }

    private static void updateInputDataDefaultName(Graph<?, Node> graph, InputData inputData) {
        String prefix = inputData.getClass().getSimpleName() + "-";
        inputData.getName().setValue(prefix + DefaultValueUtilities.getMaxUnusedIndex(DefaultValueUtilities.getExistingNodeNames(graph, inputData, n -> n.getName().getValue()), prefix));
    }

    private static void updateKnowledgeSourceDefaultName(Graph<?, Node> graph, KnowledgeSource knowledgeSource) {
        String prefix = knowledgeSource.getClass().getSimpleName() + "-";
        knowledgeSource.getName().setValue(prefix + DefaultValueUtilities.getMaxUnusedIndex(DefaultValueUtilities.getExistingNodeNames(graph, knowledgeSource, n -> n.getName().getValue()), prefix));
    }

    private static void updateTextAnnotationDefaultText(Graph<?, Node> graph, TextAnnotation textAnnotation) {
        String prefix = textAnnotation.getClass().getSimpleName() + "-";
        textAnnotation.getText().setValue(prefix + DefaultValueUtilities.getMaxUnusedIndex(DefaultValueUtilities.getExistingNodeNames(graph, textAnnotation, n -> n.getText().getValue()), prefix));
    }

    private static void updateDecisionServiceDefaultName(Graph<?, Node> graph, DecisionService decisionService) {
        String prefix = decisionService.getClass().getSimpleName() + "-";
        decisionService.getName().setValue(prefix + DefaultValueUtilities.getMaxUnusedIndex(DefaultValueUtilities.getExistingNodeNames(graph, decisionService, n -> n.getName().getValue()), prefix));
    }

    private static <T extends DMNModelInstrumentedBase> List<String> getExistingNodeNames(Graph<?, Node> graph, T dmnModel, Function<T, String> nameExtractor) {
        return StreamSupport.stream(graph.nodes().spliterator(), false).filter(node -> node.getContent() instanceof View).map(node -> (View)node.getContent()).filter(view -> view.getDefinition() instanceof DMNModelInstrumentedBase).map(view -> (DMNModelInstrumentedBase)view.getDefinition()).filter(dmn -> dmn.getClass().equals(dmnModel.getClass())).map(nameExtractor::apply).collect(Collectors.toList());
    }

    private static boolean isNameAlreadySet(NamedElement element) {
        return element.getName() != null && !StringUtils.isEmpty((String)element.getName().getValue());
    }
}

