/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.shape.factory;

import java.util.Map;
import java.util.function.Function;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.soup.commons.util.Maps;
import org.kie.workbench.common.dmn.api.definition.DMNDefinition;
import org.kie.workbench.common.dmn.api.definition.v1_1.Association;
import org.kie.workbench.common.dmn.api.definition.v1_1.AuthorityRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.InformationRequirement;
import org.kie.workbench.common.dmn.api.definition.v1_1.KnowledgeRequirement;
import org.kie.workbench.common.dmn.client.shape.DMNConnectorShape;
import org.kie.workbench.common.dmn.client.shape.def.DMNConnectorShapeDef;
import org.kie.workbench.common.dmn.client.shape.def.DMNShapeDef;
import org.kie.workbench.common.dmn.client.shape.factory.DMNConnectorShapeViewFactory;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.wires.ext.WiresConnectorViewExt;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeDefFactory;

@ApplicationScoped
public class DMNConnectorShapeFactory
implements ShapeDefFactory<DMNDefinition, DMNShapeDef, Shape> {
    private final Map<Class<? extends DMNDefinition>, Function<Double[], WiresConnectorViewExt>> VIEW_FACTORIES = new Maps.Builder().put(Association.class, points -> this.getDMNConnectorShapeViewFactory().association(points[0], points[1], points[2], points[3])).put(InformationRequirement.class, points -> this.getDMNConnectorShapeViewFactory().informationRequirement(points[0], points[1], points[2], points[3])).put(KnowledgeRequirement.class, points -> this.getDMNConnectorShapeViewFactory().knowledgeRequirement(points[0], points[1], points[2], points[3])).put(AuthorityRequirement.class, points -> this.getDMNConnectorShapeViewFactory().authorityRequirement(points[0], points[1], points[2], points[3])).build();
    private final DMNConnectorShapeViewFactory dmnConnectorShapeViewFactory;

    protected DMNConnectorShapeFactory() {
        this(null);
    }

    @Inject
    public DMNConnectorShapeFactory(DMNConnectorShapeViewFactory dmnConnectorShapeViewFactory) {
        this.dmnConnectorShapeViewFactory = dmnConnectorShapeViewFactory;
    }

    public Shape newShape(DMNDefinition instance, DMNShapeDef shapeDef) {
        DMNConnectorShapeDef dmnShapeDef = (DMNConnectorShapeDef)shapeDef;
        WiresConnectorViewExt view = this.VIEW_FACTORIES.get(instance.getClass()).apply(new Double[]{0.0, 0.0, 100.0, 100.0});
        return new DMNConnectorShape(dmnShapeDef, view);
    }

    public DMNConnectorShapeViewFactory getDMNConnectorShapeViewFactory() {
        return this.dmnConnectorShapeViewFactory;
    }
}

