/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.enterprise.event.Event;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.NOPDomainObject;
import org.kie.workbench.common.dmn.api.definition.v1_1.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.v1_1.Expression;
import org.kie.workbench.common.dmn.client.commands.factory.DefaultCanvasCommandFactory;
import org.kie.workbench.common.dmn.client.commands.factory.canvas.SetComponentWidthCommand;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.HasCellEditorControls;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridCell;
import org.kie.workbench.common.dmn.client.widgets.grid.model.DMNGridColumn;
import org.kie.workbench.common.dmn.client.widgets.layer.DMNGridLayer;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.DomainObjectSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.forms.client.event.RefreshFormPropertiesEvent;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.util.CellContextUtilities;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

public abstract class BaseGrid<E extends Expression>
extends BaseGridWidget
implements HasListSelectorControl {
    protected Optional<String> nodeUUID;
    protected HasExpression hasExpression;
    protected Optional<HasName> hasName = Optional.empty();
    protected Optional<DomainObject> selectedDomainObject = Optional.empty();
    protected final DMNGridLayer gridLayer;
    protected final SessionManager sessionManager;
    protected final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    protected final DefaultCanvasCommandFactory canvasCommandFactory;
    protected final Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent;
    protected final Event<DomainObjectSelectionEvent> domainObjectSelectionEvent;
    protected final CellEditorControlsView.Presenter cellEditorControls;
    protected final TranslationService translationService;
    protected boolean isOnlyVisualChangeAllowed;

    public BaseGrid(DMNGridLayer gridLayer, GridData gridData, GridRenderer gridRenderer, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, DefaultCanvasCommandFactory canvasCommandFactory, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent, CellEditorControlsView.Presenter cellEditorControls, TranslationService translationService) {
        this(Optional.empty(), HasExpression.NOP, Optional.empty(), gridLayer, gridData, gridRenderer, sessionManager, sessionCommandManager, canvasCommandFactory, refreshFormPropertiesEvent, domainObjectSelectionEvent, cellEditorControls, translationService, false);
    }

    public BaseGrid(Optional<String> nodeUUID, HasExpression hasExpression, Optional<HasName> hasName, DMNGridLayer gridLayer, GridData gridData, GridRenderer gridRenderer, SessionManager sessionManager, SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, DefaultCanvasCommandFactory canvasCommandFactory, Event<RefreshFormPropertiesEvent> refreshFormPropertiesEvent, Event<DomainObjectSelectionEvent> domainObjectSelectionEvent, CellEditorControlsView.Presenter cellEditorControls, TranslationService translationService, boolean isOnlyVisualChangeAllowed) {
        super(gridData, (GridSelectionManager)gridLayer, (GridPinnedModeManager)gridLayer, gridRenderer);
        this.nodeUUID = nodeUUID;
        this.hasExpression = hasExpression;
        this.hasName = hasName;
        this.gridLayer = gridLayer;
        this.sessionManager = sessionManager;
        this.sessionCommandManager = sessionCommandManager;
        this.canvasCommandFactory = canvasCommandFactory;
        this.refreshFormPropertiesEvent = refreshFormPropertiesEvent;
        this.domainObjectSelectionEvent = domainObjectSelectionEvent;
        this.cellEditorControls = cellEditorControls;
        this.translationService = translationService;
        this.isOnlyVisualChangeAllowed = isOnlyVisualChangeAllowed;
    }

    protected double getAndSetInitialWidth(int uiColumnIndex, double initialWidth) {
        if (this.getExpression().get().isPresent()) {
            Expression e = (Expression)this.getExpression().get().get();
            List componentWidths = e.getComponentWidths();
            if (Objects.isNull(componentWidths.get(uiColumnIndex))) {
                componentWidths.set(uiColumnIndex, initialWidth);
            }
            return (Double)componentWidths.get(uiColumnIndex);
        }
        throw new IllegalStateException("Unable to initialise column width if Expression has not been set.");
    }

    public Supplier<Optional<E>> getExpression() {
        return () -> Optional.ofNullable(this.cast(this.hasExpression.getExpression()));
    }

    private E cast(Expression e) {
        return (E)e;
    }

    protected void fireDomainObjectSelectionEvent() {
        Optional<CanvasHandler> canvasHandler = this.getCanvasHandler();
        if (!canvasHandler.isPresent()) {
            return;
        }
        Optional<DomainObject> domainObject = this.getDomainObject();
        if (!domainObject.isPresent()) {
            this.domainObjectSelectionEvent.fire((Object)new DomainObjectSelectionEvent(canvasHandler.get(), (DomainObject)new NOPDomainObject()));
            return;
        }
        this.fireDomainObjectSelectionEvent(domainObject.get());
    }

    protected void fireDomainObjectSelectionEvent(DomainObject domainObject) {
        Optional<CanvasHandler> canvasHandler = this.getCanvasHandler();
        if (!canvasHandler.isPresent()) {
            return;
        }
        Optional<Node> domainObjectNode = this.findDomainObjectNodeByDomainObject(domainObject);
        if (domainObjectNode.isPresent()) {
            this.refreshFormPropertiesEvent.fire((Object)new RefreshFormPropertiesEvent(this.getCurrentSession(), domainObjectNode.get().getUUID()));
            this.selectedDomainObject = Optional.empty();
        } else {
            this.domainObjectSelectionEvent.fire((Object)new DomainObjectSelectionEvent(canvasHandler.get(), domainObject));
            this.selectedDomainObject = Optional.of(domainObject);
        }
    }

    private Optional<DomainObject> getDomainObject() {
        if (this.hasExpression == null) {
            return Optional.empty();
        }
        DMNModelInstrumentedBase base = this.hasExpression.asDMNModelInstrumentedBase();
        if (base instanceof DomainObject) {
            return Optional.of((DomainObject)base);
        }
        return Optional.empty();
    }

    private Optional<CanvasHandler> getCanvasHandler() {
        Optional<ClientSession> session = Optional.ofNullable(this.getCurrentSession());
        return session.map(ClientSession::getCanvasHandler);
    }

    private ClientSession getCurrentSession() {
        return this.sessionManager.getCurrentSession();
    }

    private Optional<Node> findDomainObjectNodeByDomainObject(DomainObject domainObject) {
        return this.getCanvasHandler().map(canvasHandler -> {
            Graph graph = canvasHandler.getDiagram().getGraph();
            return StreamSupport.stream(graph.nodes().spliterator(), false).filter(node -> node.getContent() instanceof Definition).filter(node -> Objects.equals(domainObject, ((Definition)node.getContent()).getDefinition())).findFirst();
        }).orElse(Optional.empty());
    }

    public void registerColumnResizeCompleted(DMNGridColumn uiColumn, double uiColumnInitialWidth) {
        this.getCanvasHandler().ifPresent(canvasHandler -> {
            AbstractCanvasHandler abstractCanvasHandler = (AbstractCanvasHandler)canvasHandler;
            SetComponentWidthCommand command = new SetComponentWidthCommand(uiColumn, uiColumnInitialWidth, uiColumn.getWidth());
            this.sessionCommandManager.execute((Object)abstractCanvasHandler, (Command)command);
        });
    }

    public boolean showContextMenuForHeader(int uiHeaderRowIndex, int uiHeaderColumnIndex) {
        GridColumn.HeaderMetaData hasCellEditorControls = (GridColumn.HeaderMetaData)((GridColumn)this.model.getColumns().get(uiHeaderColumnIndex)).getHeaderMetaData().get(uiHeaderRowIndex);
        if (hasCellEditorControls instanceof HasCellEditorControls && ((HasCellEditorControls)hasCellEditorControls).getEditor().isPresent()) {
            HasCellEditorControls.Editor editor = ((HasCellEditorControls)hasCellEditorControls).getEditor().get();
            return this.doShowContextMenu(editor, (ri, ci) -> CellContextUtilities.makeHeaderCellRenderContext((GridWidget)this, (BaseGridRendererHelper.RenderingInformation)ri, (BaseGridRendererHelper.ColumnInformation)ci, (int)uiHeaderRowIndex), uiHeaderRowIndex, uiHeaderColumnIndex, hasCellEditorControls);
        }
        return super.showContextMenuForHeader(uiHeaderRowIndex, uiHeaderColumnIndex);
    }

    public boolean showContextMenuForCell(int uiRowIndex, int uiColumnIndex) {
        GridCell cell = this.model.getCell(uiRowIndex, uiColumnIndex);
        if (cell instanceof DMNGridCell && ((DMNGridCell)cell).getEditor().isPresent()) {
            HasCellEditorControls.Editor editor = (HasCellEditorControls.Editor)((DMNGridCell)cell).getEditor().get();
            return this.doShowContextMenu(editor, (ri, ci) -> CellContextUtilities.makeCellRenderContext((GridWidget)this, (BaseGridRendererHelper.RenderingInformation)ri, (BaseGridRendererHelper.ColumnInformation)ci, (int)uiRowIndex), uiRowIndex, uiColumnIndex, this);
        }
        return super.showContextMenuForCell(uiRowIndex, uiColumnIndex);
    }

    private boolean doShowContextMenu(HasCellEditorControls.Editor editor, BiFunction<BaseGridRendererHelper.RenderingInformation, BaseGridRendererHelper.ColumnInformation, GridBodyCellEditContext> contextSupplier, int uiRowIndex, int uiColumnIndex, Object binding) {
        GridColumn column = (GridColumn)this.model.getColumns().get(uiColumnIndex);
        BaseGridRendererHelper.RenderingInformation ri = this.rendererHelper.getRenderingInformation();
        double columnXCoordinate = this.rendererHelper.getColumnOffset(column) + column.getWidth() / 2.0;
        BaseGridRendererHelper.ColumnInformation ci = this.rendererHelper.getColumnInformation(columnXCoordinate);
        GridBodyCellEditContext context = contextSupplier.apply(ri, ci);
        double cellWidth = context.getCellWidth();
        double cellHeight = context.getCellHeight();
        editor.bind(binding, uiRowIndex, uiColumnIndex);
        this.cellEditorControls.show(editor, Optional.empty(), (int)(context.getAbsoluteCellX() + cellWidth / 2.0), (int)(context.getAbsoluteCellY() + cellHeight / 2.0));
        return true;
    }

    public boolean isOnlyVisualChangeAllowed() {
        return this.isOnlyVisualChangeAllowed;
    }
}

