/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.api.included.legacy;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedModel;
import org.kie.workbench.common.dmn.api.editors.included.DMNIncludedNode;
import org.kie.workbench.common.dmn.api.editors.included.IncludedModel;
import org.kie.workbench.common.dmn.client.service.DMNClientServicesProxy;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.uberfire.backend.vfs.Path;

@Dependent
public class DMNIncludeModelsClient {
    private final DMNClientServicesProxy clientServicesProxy;

    @Inject
    public DMNIncludeModelsClient(DMNClientServicesProxy clientServicesProxy) {
        this.clientServicesProxy = clientServicesProxy;
    }

    public void loadModels(Path path, Consumer<List<IncludedModel>> listConsumer) {
        this.clientServicesProxy.loadModels(path, this.callback(listConsumer));
    }

    public void loadNodesFromImports(List<DMNIncludedModel> includeModels, Consumer<List<DMNIncludedNode>> consumer) {
        this.clientServicesProxy.loadNodesFromImports(includeModels, this.callback(consumer));
    }

    public void loadItemDefinitionsByNamespace(String modelName, String namespace, Consumer<List<ItemDefinition>> consumer) {
        this.clientServicesProxy.loadItemDefinitionsByNamespace(modelName, namespace, this.callback(consumer));
    }

    <T> ServiceCallback<List<T>> callback(final Consumer<List<T>> consumer) {
        return new ServiceCallback<List<T>>(){

            public void onSuccess(List<T> item) {
                consumer.accept(item);
            }

            public void onError(ClientRuntimeError error) {
                DMNIncludeModelsClient.this.clientServicesProxy.logWarning(error);
                consumer.accept(new ArrayList());
            }
        };
    }
}

