/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.context;

import java.util.stream.IntStream;
import org.kie.workbench.common.dmn.api.definition.model.Context;
import org.kie.workbench.common.dmn.api.definition.model.ContextEntry;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.InformationItem;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextEntryDefaultValueUtilities;
import org.kie.workbench.common.dmn.client.editors.expressions.types.context.ContextUIModelMapper;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.mvp.Command;

public class AddContextEntryCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final Context context;
    private final ContextEntry contextEntry;
    private final GridData uiModel;
    private final GridRow uiModelRow;
    private final int uiRowIndex;
    private final ContextUIModelMapper uiModelMapper;
    private final Command canvasOperation;
    private final String name;

    public AddContextEntryCommand(Context context, ContextEntry contextEntry, GridData uiModel, GridRow uiModelRow, int uiRowIndex, ContextUIModelMapper uiModelMapper, Command canvasOperation) {
        this.context = context;
        this.contextEntry = contextEntry;
        this.uiModel = uiModel;
        this.uiModelRow = uiModelRow;
        this.uiRowIndex = uiRowIndex;
        this.uiModelMapper = uiModelMapper;
        this.canvasOperation = canvasOperation;
        this.name = ContextEntryDefaultValueUtilities.getNewContextEntryName(context);
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler handler) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext gce) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext gce) {
                AddContextEntryCommand.this.context.getContextEntry().add(AddContextEntryCommand.this.uiRowIndex, AddContextEntryCommand.this.contextEntry);
                InformationItem informationItem = AddContextEntryCommand.this.contextEntry.getVariable();
                informationItem.getName().setValue(AddContextEntryCommand.this.name);
                AddContextEntryCommand.this.contextEntry.setParent((DMNModelInstrumentedBase)AddContextEntryCommand.this.context);
                AddContextEntryCommand.this.contextEntry.getVariable().setParent((DMNModelInstrumentedBase)AddContextEntryCommand.this.contextEntry);
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext gce) {
                AddContextEntryCommand.this.context.getContextEntry().remove(AddContextEntryCommand.this.contextEntry);
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler handler) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler handler) {
                AddContextEntryCommand.this.uiModel.insertRow(AddContextEntryCommand.this.uiRowIndex, AddContextEntryCommand.this.uiModelRow);
                AddContextEntryCommand.this.uiModelMapper.fromDMNModel(AddContextEntryCommand.this.uiRowIndex, 0);
                AddContextEntryCommand.this.uiModelMapper.fromDMNModel(AddContextEntryCommand.this.uiRowIndex, 1);
                AddContextEntryCommand.this.uiModelMapper.fromDMNModel(AddContextEntryCommand.this.uiRowIndex, 2);
                AddContextEntryCommand.this.updateRowNumbers();
                AddContextEntryCommand.this.updateParentInformation();
                AddContextEntryCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler handler) {
                int rowIndex = AddContextEntryCommand.this.uiModel.getRows().indexOf(AddContextEntryCommand.this.uiModelRow);
                AddContextEntryCommand.this.uiModel.deleteRow(rowIndex);
                AddContextEntryCommand.this.updateRowNumbers();
                AddContextEntryCommand.this.updateParentInformation();
                AddContextEntryCommand.this.canvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }

    public void updateRowNumbers() {
        CommandUtils.updateRowNumbers(this.uiModel, IntStream.range(0, this.uiModel.getRowCount() - 1));
    }

    public void updateParentInformation() {
        CommandUtils.updateParentInformation(this.uiModel);
    }
}

