/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.commands.expressions.types.dtable;

import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.api.definition.model.DMNModelInstrumentedBase;
import org.kie.workbench.common.dmn.api.definition.model.DecisionTable;
import org.kie.workbench.common.dmn.api.definition.model.InputClause;
import org.kie.workbench.common.dmn.api.definition.model.InputClauseLiteralExpression;
import org.kie.workbench.common.dmn.api.definition.model.UnaryTests;
import org.kie.workbench.common.dmn.client.commands.VetoExecutionCommand;
import org.kie.workbench.common.dmn.client.commands.VetoUndoCommand;
import org.kie.workbench.common.dmn.client.commands.util.CommandUtils;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableDefaultValueUtilities;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableUIModelMapper;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.InputClauseColumn;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandResultBuilder;
import org.kie.workbench.common.stunner.core.graph.command.impl.AbstractGraphCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.mvp.Command;

public class AddInputClauseCommand
extends AbstractCanvasGraphCommand
implements VetoExecutionCommand,
VetoUndoCommand {
    private final DecisionTable dtable;
    private final InputClause inputClause;
    private final GridData uiModel;
    private final Supplier<InputClauseColumn> uiModelColumnSupplier;
    private final int uiColumnIndex;
    private final DecisionTableUIModelMapper uiModelMapper;
    private final Command executeCanvasOperation;
    private final Command undoCanvasOperation;
    private final String name;
    private Optional<InputClauseColumn> uiModelColumn = Optional.empty();

    public AddInputClauseCommand(DecisionTable dtable, InputClause inputClause, GridData uiModel, Supplier<InputClauseColumn> uiModelColumnSupplier, int uiColumnIndex, DecisionTableUIModelMapper uiModelMapper, Command executeCanvasOperation, Command undoCanvasOperation) {
        this.dtable = dtable;
        this.inputClause = inputClause;
        this.uiModel = uiModel;
        this.uiModelColumnSupplier = uiModelColumnSupplier;
        this.uiColumnIndex = uiColumnIndex;
        this.uiModelMapper = uiModelMapper;
        this.executeCanvasOperation = executeCanvasOperation;
        this.undoCanvasOperation = undoCanvasOperation;
        this.name = DecisionTableDefaultValueUtilities.getNewInputClauseName(dtable);
    }

    protected org.kie.workbench.common.stunner.core.command.Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new AbstractGraphCommand(){

            protected CommandResult<RuleViolation> check(GraphCommandExecutionContext context) {
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> execute(GraphCommandExecutionContext context) {
                AddInputClauseCommand.this.dtable.getComponentWidths().add(AddInputClauseCommand.this.uiColumnIndex, null);
                int clauseIndex = AddInputClauseCommand.this.uiColumnIndex - 1;
                AddInputClauseCommand.this.dtable.getInput().add(clauseIndex, AddInputClauseCommand.this.inputClause);
                InputClauseLiteralExpression le = new InputClauseLiteralExpression();
                AddInputClauseCommand.this.inputClause.setInputExpression(le);
                le.getText().setValue(AddInputClauseCommand.this.name);
                AddInputClauseCommand.this.dtable.getRule().forEach(rule -> {
                    UnaryTests ut = new UnaryTests();
                    ut.getText().setValue("");
                    rule.getInputEntry().add(clauseIndex, ut);
                    ut.setParent((DMNModelInstrumentedBase)rule);
                });
                AddInputClauseCommand.this.inputClause.setParent((DMNModelInstrumentedBase)AddInputClauseCommand.this.dtable);
                return GraphCommandResultBuilder.SUCCESS;
            }

            public CommandResult<RuleViolation> undo(GraphCommandExecutionContext context) {
                AddInputClauseCommand.this.dtable.getComponentWidths().remove(AddInputClauseCommand.this.uiColumnIndex);
                int clauseIndex = AddInputClauseCommand.this.dtable.getInput().indexOf(AddInputClauseCommand.this.inputClause);
                AddInputClauseCommand.this.dtable.getRule().forEach(rule -> {
                    UnaryTests cfr_ignored_0 = (UnaryTests)rule.getInputEntry().remove(clauseIndex);
                });
                AddInputClauseCommand.this.dtable.getInput().remove(AddInputClauseCommand.this.inputClause);
                return GraphCommandResultBuilder.SUCCESS;
            }
        };
    }

    protected org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler context) {
        return new AbstractCanvasCommand(){

            public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
                if (!AddInputClauseCommand.this.uiModelColumn.isPresent()) {
                    AddInputClauseCommand.this.uiModelColumn = Optional.of(AddInputClauseCommand.this.uiModelColumnSupplier.get());
                }
                AddInputClauseCommand.this.uiModel.insertColumn(AddInputClauseCommand.this.uiColumnIndex, (GridColumn)AddInputClauseCommand.this.uiModelColumn.get());
                for (int rowIndex = 0; rowIndex < AddInputClauseCommand.this.dtable.getRule().size(); ++rowIndex) {
                    AddInputClauseCommand.this.uiModelMapper.fromDMNModel(rowIndex, AddInputClauseCommand.this.uiColumnIndex);
                }
                AddInputClauseCommand.this.updateParentInformation();
                AddInputClauseCommand.this.executeCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }

            public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
                AddInputClauseCommand.this.uiModelColumn.ifPresent(arg_0 -> ((GridData)AddInputClauseCommand.this.uiModel).deleteColumn(arg_0));
                AddInputClauseCommand.this.updateParentInformation();
                AddInputClauseCommand.this.undoCanvasOperation.execute();
                return CanvasCommandResultBuilder.SUCCESS;
            }
        };
    }

    public void updateParentInformation() {
        CommandUtils.updateParentInformation(this.uiModel);
    }
}

