/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.documentation.common;

import com.ait.lienzo.client.core.shape.Viewport;
import com.ait.lienzo.shared.core.types.DataURLType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.HasExpression;
import org.kie.workbench.common.dmn.api.definition.HasName;
import org.kie.workbench.common.dmn.api.definition.HasVariable;
import org.kie.workbench.common.dmn.api.definition.model.DRGElement;
import org.kie.workbench.common.dmn.api.property.dmn.DMNExternalLink;
import org.kie.workbench.common.dmn.api.property.dmn.QName;
import org.kie.workbench.common.dmn.client.common.BoxedExpressionHelper;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationDRD;
import org.kie.workbench.common.dmn.client.editors.documentation.common.DMNDocumentationExternalLink;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionContainerGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorView;
import org.kie.workbench.common.dmn.client.editors.expressions.ExpressionEditorViewImpl;
import org.kie.workbench.common.dmn.client.session.DMNSession;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class DMNDocumentationDRDsFactory {
    static final String NONE = "";
    private final SessionManager sessionManager;
    private final BoxedExpressionHelper expressionHelper;

    @Inject
    public DMNDocumentationDRDsFactory(SessionManager sessionManager, BoxedExpressionHelper expressionHelper) {
        this.sessionManager = sessionManager;
        this.expressionHelper = expressionHelper;
    }

    public List<DMNDocumentationDRD> create(Diagram diagram) {
        Optional<String> previousNodeUUID = this.getExpressionContainerGrid().getNodeUUID();
        List<DMNDocumentationDRD> drds = this.createDMNDocumentationDRDs(diagram);
        previousNodeUUID.ifPresent(uuid -> this.setExpressionContainerGrid(diagram, (String)uuid));
        return drds;
    }

    String getNodeImage(Diagram diagram, Node<View, Edge> node) {
        if (!this.hasExpression(node)) {
            return NONE;
        }
        this.setExpressionContainerGrid(diagram, node.getUUID());
        ExpressionContainerGrid grid = this.getExpressionContainerGrid();
        Viewport viewport = grid.getViewport();
        int padding = 10;
        int wide = (int)(grid.getWidth() + 10.0);
        int high = (int)(grid.getHeight() + 10.0);
        viewport.setPixelSize(wide, high);
        return viewport.toDataURL(DataURLType.PNG);
    }

    void clearSelections(ExpressionContainerGrid grid) {
        grid.getBaseExpressionGrid().ifPresent(expressionGrid -> {
            expressionGrid.getModel().clearSelections();
            expressionGrid.draw();
        });
    }

    void setExpressionContainerGrid(Diagram diagram, String uuid) {
        Node<View, Edge> node = this.getNode(diagram, uuid);
        Object definition = this.expressionHelper.getDefinition(node);
        HasExpression hasExpression = this.expressionHelper.getHasExpression(node);
        Optional<HasName> hasName = Optional.of((HasName)definition);
        ExpressionContainerGrid grid = this.getExpressionContainerGrid();
        grid.setExpression(node.getUUID(), hasExpression, hasName, false);
        this.clearSelections(grid);
    }

    private List<DMNDocumentationDRD> createDMNDocumentationDRDs(Diagram diagram) {
        ArrayList<DMNDocumentationDRD> dmnDocumentationDRDS = new ArrayList<DMNDocumentationDRD>();
        this.getNodeStream(diagram).forEach(node -> {
            Object definition = this.expressionHelper.getDefinition((Node<View, Edge>)node);
            if (definition instanceof DRGElement) {
                DRGElement drgElement = (DRGElement)definition;
                dmnDocumentationDRDS.add(this.createDMNDocumentationDRD(diagram, (Node<View, Edge>)node, drgElement));
            }
        });
        return dmnDocumentationDRDS;
    }

    private DMNDocumentationDRD createDMNDocumentationDRD(Diagram diagram, Node<View, Edge> node, DRGElement drgElement) {
        List<DMNDocumentationExternalLink> externalLinks;
        String name = this.getName(drgElement);
        String description = this.getDescription(drgElement);
        String type = this.getType(drgElement);
        String image = this.getNodeImage(diagram, node);
        return DMNDocumentationDRD.create(name, type, description, image, externalLinks, !(externalLinks = this.getExternalLinks(drgElement)).isEmpty());
    }

    private List<DMNDocumentationExternalLink> getExternalLinks(DRGElement drgElement) {
        ArrayList<DMNDocumentationExternalLink> list = new ArrayList<DMNDocumentationExternalLink>();
        if (!Objects.isNull(drgElement.getLinksHolder()) && !Objects.isNull(drgElement.getLinksHolder().getValue())) {
            for (DMNExternalLink link : drgElement.getLinksHolder().getValue().getLinks()) {
                list.add(DMNDocumentationExternalLink.create(link.getDescription(), link.getUrl()));
            }
        }
        return list;
    }

    private String getType(DRGElement drgElement) {
        if (drgElement instanceof HasVariable) {
            return this.getType(((HasVariable)drgElement).getVariable().getTypeRef());
        }
        return NONE;
    }

    private String getType(QName qName) {
        return Optional.ofNullable(qName).map(QName::getLocalPart).orElse(NONE);
    }

    private String getName(DRGElement drgElement) {
        return drgElement.getName().getValue();
    }

    private String getDescription(DRGElement drgElement) {
        return drgElement.getDescription().getValue();
    }

    private ExpressionContainerGrid getExpressionContainerGrid() {
        ExpressionEditorView.Presenter expressionEditor = this.getCurrentSession().getExpressionEditor();
        return ((ExpressionEditorViewImpl)expressionEditor.getView()).getExpressionContainerGrid();
    }

    private boolean hasExpression(Node<View, Edge> node) {
        return this.expressionHelper.getOptionalHasExpression(node).isPresent();
    }

    private DMNSession getCurrentSession() {
        return (DMNSession)this.sessionManager.getCurrentSession();
    }

    private Node<View, Edge> getNode(Diagram diagram, String uuid) {
        return this.getNodeStream(diagram).filter(node -> Objects.equals(uuid, node.getUUID())).findFirst().orElseThrow(UnsupportedOperationException::new);
    }

    private Stream<Node<View, Edge>> getNodeStream(Diagram diagram) {
        Graph graph = diagram.getGraph();
        Iterable nodes = graph.nodes();
        return StreamSupport.stream(nodes.spliterator(), false).map(node -> node);
    }
}

