/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.dtable;

import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.api.definition.model.BuiltinAggregator;
import org.kie.workbench.common.dmn.api.definition.model.HitPolicy;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.DecisionTableGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.HasHitPolicyControl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.dtable.hitpolicy.HitPolicyPopoverView;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditablePopupHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;

class RowNumberColumnHeaderMetaData
extends EditablePopupHeaderMetaData<HasHitPolicyControl, HitPolicyPopoverView.Presenter> {
    private static final String ROW_NUMBER_GROUP = "RowNumberColumn";
    private final Supplier<HitPolicy> hitPolicySupplier;
    private final Supplier<BuiltinAggregator> builtinAggregatorSupplier;
    private final DecisionTableGrid gridWidget;

    public RowNumberColumnHeaderMetaData(Supplier<HitPolicy> hitPolicySupplier, Supplier<BuiltinAggregator> builtinAggregatorSupplier, CellEditorControlsView.Presenter cellEditorControls, HitPolicyPopoverView.Presenter editor, Optional<String> editorTitle, DecisionTableGrid gridWidget) {
        super(cellEditorControls, editor, editorTitle);
        this.hitPolicySupplier = hitPolicySupplier;
        this.builtinAggregatorSupplier = builtinAggregatorSupplier;
        this.gridWidget = gridWidget;
    }

    @Override
    protected HasHitPolicyControl getPresenter() {
        return this.gridWidget;
    }

    public String getColumnGroup() {
        return ROW_NUMBER_GROUP;
    }

    @Override
    public void setColumnGroup(String columnGroup) {
        throw new UnsupportedOperationException("Group cannot be set.");
    }

    public String getTitle() {
        HitPolicy hitPolicy = this.hitPolicySupplier.get();
        BuiltinAggregator builtinAggregator = this.builtinAggregatorSupplier.get();
        StringBuilder sb = new StringBuilder(hitPolicy.value().substring(0, 1).toUpperCase());
        if (HitPolicy.COLLECT == hitPolicy && builtinAggregator != null) {
            sb.append(builtinAggregator.getCode());
        }
        return sb.toString();
    }
}

