/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.expressions.types.function;

import com.ait.lienzo.client.core.shape.Group;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.model.FunctionDefinition;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.FunctionGrid;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.KindUtilities;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.HasParametersControl;
import org.kie.workbench.common.dmn.client.editors.expressions.types.function.parameters.ParametersPopoverView;
import org.kie.workbench.common.dmn.client.editors.expressions.util.RendererUtils;
import org.kie.workbench.common.dmn.client.widgets.grid.columns.EditablePopupHeaderMetaData;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.container.CellEditorControlsView;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridHeaderColumnRenderContext;

public class FunctionColumnParametersHeaderMetaData
extends EditablePopupHeaderMetaData<HasParametersControl, ParametersPopoverView.Presenter> {
    static final String PARAMETER_COLUMN_GROUP = "FunctionColumnParametersHeaderMetaData$Parameters";
    private final Supplier<Optional<FunctionDefinition>> functionSupplier;
    private final FunctionGrid gridWidget;
    private final TranslationService translationService;

    public FunctionColumnParametersHeaderMetaData(Supplier<Optional<FunctionDefinition>> functionSupplier, TranslationService translationService, CellEditorControlsView.Presenter cellEditorControls, ParametersPopoverView.Presenter editor, Optional<String> editorTitle, FunctionGrid gridWidget) {
        super(cellEditorControls, editor, editorTitle);
        this.functionSupplier = functionSupplier;
        this.translationService = translationService;
        this.gridWidget = gridWidget;
    }

    @Override
    protected HasParametersControl getPresenter() {
        return this.gridWidget;
    }

    public String getColumnGroup() {
        return PARAMETER_COLUMN_GROUP;
    }

    public String getTitle() {
        return this.getFormalParametersTitle();
    }

    @Override
    public Group render(GridHeaderColumnRenderContext context, double blockWidth, double blockHeight) {
        if (!this.hasFormalParametersSet()) {
            return RendererUtils.getEditableHeaderPlaceHolderText(this, context, blockWidth, blockHeight);
        }
        return super.render(context, blockWidth, blockHeight);
    }

    @Override
    public Optional<String> getPlaceHolder() {
        return Optional.of(this.translationService.getTranslation("FunctionEditor.EditParameters"));
    }

    String getExpressionLanguageTitle() {
        FunctionDefinition.Kind kind = KindUtilities.getKind(this.functionSupplier.get().get());
        return kind == null ? this.translationService.getTranslation("FunctionEditor.Undefined") : kind.code();
    }

    String getFormalParametersTitle() {
        List formalParameters = this.functionSupplier.get().get().getFormalParameter();
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (!formalParameters.isEmpty()) {
            sb.append(formalParameters.stream().map(ii -> ii.getName().getValue()).collect(Collectors.joining(", ")));
        }
        sb.append(")");
        return sb.toString();
    }

    boolean hasFormalParametersSet() {
        return !this.functionSupplier.get().get().getFormalParameter().isEmpty();
    }
}

