/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview;

import elemental2.dom.HTMLElement;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.ConstraintType;
import org.kie.workbench.common.dmn.api.property.dmn.types.BuiltInType;
import org.kie.workbench.common.dmn.client.editors.types.DataTypeChangedEvent;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeList;
import org.kie.workbench.common.dmn.client.editors.types.listview.DataTypeSelect;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.DataTypeEditModeToggleEvent;
import org.kie.workbench.common.dmn.client.editors.types.listview.common.SmallSwitchComponent;
import org.kie.workbench.common.dmn.client.editors.types.listview.confirmation.DataTypeConfirmation;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraint;
import org.kie.workbench.common.dmn.client.editors.types.listview.validation.DataTypeNameFormatValidator;
import org.kie.workbench.common.dmn.client.editors.types.persistence.CreationType;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.mvp.Command;

@Dependent
public class DataTypeListItem {
    private final View view;
    private final DataTypeSelect dataTypeSelectComponent;
    private final DataTypeConstraint dataTypeConstraintComponent;
    private final SmallSwitchComponent dataTypeListComponent;
    private final DataTypeManager dataTypeManager;
    private final DataTypeConfirmation confirmation;
    private final Event<DataTypeEditModeToggleEvent> editModeToggleEvent;
    private final DataTypeNameFormatValidator nameFormatValidator;
    private final Event<DataTypeChangedEvent> dataTypeChangedEvent;
    private DataType dataType;
    private int level;
    private DataTypeList dataTypeList;
    private String oldName;
    private String oldType;
    private String oldConstraint;
    private boolean oldIsList;
    private ConstraintType oldConstraintType;
    private String[] canNotHaveConstraintTypes;

    @Inject
    public DataTypeListItem(View view, DataTypeSelect dataTypeSelectComponent, DataTypeConstraint dataTypeConstraintComponent, SmallSwitchComponent dataTypeListComponent, DataTypeManager dataTypeManager, DataTypeConfirmation confirmation, DataTypeNameFormatValidator nameFormatValidator, Event<DataTypeEditModeToggleEvent> editModeToggleEvent, Event<DataTypeChangedEvent> dataTypeChangedEvent) {
        this.view = view;
        this.dataTypeSelectComponent = dataTypeSelectComponent;
        this.dataTypeConstraintComponent = dataTypeConstraintComponent;
        this.dataTypeListComponent = dataTypeListComponent;
        this.dataTypeManager = dataTypeManager;
        this.confirmation = confirmation;
        this.nameFormatValidator = nameFormatValidator;
        this.editModeToggleEvent = editModeToggleEvent;
        this.dataTypeChangedEvent = dataTypeChangedEvent;
        this.dataTypeListComponent.setOnValueChanged(value -> this.refreshConstraintComponent());
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
        this.canNotHaveConstraintTypes = new String[]{BuiltInType.BOOLEAN.getName(), this.dataTypeManager.structure(), BuiltInType.CONTEXT.getName()};
    }

    public void init(DataTypeList dataTypeList) {
        this.dataTypeList = dataTypeList;
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    void setupDataType(DataType dataType, int level) {
        this.dataType = dataType;
        this.level = level;
        this.setupSelectComponent();
        this.setupListComponent();
        this.setupConstraintComponent();
        this.setupView();
    }

    void setupListComponent() {
        this.dataTypeListComponent.setValue(this.getDataType().isList());
        this.refreshListYesLabel();
    }

    void setupConstraintComponent() {
        this.dataTypeConstraintComponent.init(this);
        this.refreshConstraintComponent();
    }

    void setupSelectComponent() {
        this.dataTypeSelectComponent.init(this, this.getDataType());
    }

    void setupView() {
        this.view.setupSelectComponent(this.dataTypeSelectComponent);
        this.view.setupConstraintComponent(this.dataTypeConstraintComponent);
        this.view.setupListComponent(this.dataTypeListComponent);
        this.view.setDataType(this.getDataType());
    }

    void refresh() {
        this.dataTypeSelectComponent.refresh();
        this.dataTypeSelectComponent.init(this, this.getDataType());
        this.dataTypeConstraintComponent.refreshView();
        this.view.setName(this.getDataType().getName());
        this.setupListComponent();
        this.setupConstraintComponent();
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isReadOnly() {
        return this.getDataType().isReadOnly();
    }

    public int getLevel() {
        return this.level;
    }

    public String[] getCanNotHaveConstraintTypes() {
        return this.canNotHaveConstraintTypes;
    }

    void expandOrCollapseSubTypes() {
        if (this.view.isCollapsed()) {
            this.expand();
        } else {
            this.collapse();
        }
    }

    public void expand() {
        this.view.expand();
    }

    public void collapse() {
        this.view.collapse();
    }

    void refreshSubItems(List<DataType> dataTypes) {
        this.dataTypeList.refreshSubItemsFromListItem(this, dataTypes);
        this.view.enableFocusMode();
        this.view.toggleArrow(!dataTypes.isEmpty());
    }

    public void enableEditMode() {
        if (this.view.isOnFocusMode()) {
            return;
        }
        this.oldName = this.getDataType().getName();
        this.oldType = this.getDataType().getType();
        this.oldConstraint = this.getDataType().getConstraint();
        this.oldIsList = this.getDataType().isList();
        this.oldConstraintType = this.getDataType().getConstraintType();
        this.view.showSaveButton();
        this.view.showDataTypeNameInput();
        this.view.showListContainer();
        this.view.hideKebabMenu();
        this.view.hideListYesLabel();
        this.view.enableFocusMode();
        this.dataTypeSelectComponent.enableEditMode();
        this.dataTypeConstraintComponent.enableEditMode();
        this.editModeToggleEvent.fire((Object)new DataTypeEditModeToggleEvent(true, this));
    }

    public void disableEditMode() {
        if (this.view.isOnFocusMode()) {
            this.discardNewDataType();
            this.closeEditMode();
        }
    }

    public void saveAndCloseEditMode() {
        DataType updatedDataType = this.updateProperties(this.getDataType());
        if (updatedDataType.isValid()) {
            this.confirmation.ifDataTypeDoesNotHaveLostSubDataTypes(updatedDataType, this.doValidateDataTypeNameAndSave(updatedDataType), this.doDisableEditMode());
        } else {
            this.discardDataTypeProperties();
        }
    }

    Command doDisableEditMode() {
        return this::disableEditMode;
    }

    Command doValidateDataTypeNameAndSave(DataType dataType) {
        return () -> this.nameFormatValidator.ifIsValid(dataType, this.doSaveAndCloseEditMode(dataType));
    }

    Command doSaveAndCloseEditMode(DataType dataType) {
        return () -> {
            String referenceDataTypeHash = this.dataTypeList.calculateParentHash(dataType);
            this.dataTypeList.refreshItemsByUpdatedDataTypes(this.persist(dataType));
            this.closeEditMode();
            String newDataTypeHash = this.getNewDataTypeHash(dataType, referenceDataTypeHash);
            this.dataTypeList.fireOnDataTypeListItemUpdateCallback(newDataTypeHash);
            this.insertNewFieldIfDataTypeIsStructure(newDataTypeHash);
            this.fireDataChangedEvent();
        };
    }

    void fireDataChangedEvent() {
        this.dataTypeChangedEvent.fire((Object)new DataTypeChangedEvent());
    }

    void insertNewFieldIfDataTypeIsStructure(String hash) {
        Optional<DataTypeListItem> updatedItem = this.dataTypeList.findItemByDataTypeHash(hash);
        updatedItem.ifPresent(item -> {
            if (item.isStructureType() && !item.getDataType().hasSubDataTypes()) {
                this.dataTypeList.insertNestedField(hash);
            }
        });
    }

    List<DataType> persist(DataType dataType) {
        return this.dataTypeManager.from(dataType).withSubDataTypes(this.dataTypeSelectComponent.getSubDataTypes()).get().update();
    }

    void discardNewDataType() {
        DataType oldDataType = this.discardDataTypeProperties();
        this.view.setDataType(oldDataType);
        this.setupListComponent();
        this.setupSelectComponent();
        this.setupConstraintComponent();
        this.refreshSubItems(oldDataType.getSubDataTypes());
    }

    DataType discardDataTypeProperties() {
        return this.dataTypeManager.withDataType(this.getDataType()).withName(this.getOldName()).withType(this.getOldType()).withConstraint(this.getOldConstraint()).withConstraintType(this.getOldConstraintType()).asList(this.getOldIsList()).get();
    }

    void closeEditMode() {
        this.view.hideDataTypeNameInput();
        this.view.hideListContainer();
        this.view.showEditButton();
        this.view.showKebabMenu();
        this.view.disableFocusMode();
        this.refreshListYesLabel();
        this.dataTypeSelectComponent.disableEditMode();
        this.dataTypeConstraintComponent.disableEditMode();
        this.editModeToggleEvent.fire((Object)new DataTypeEditModeToggleEvent(false, this));
    }

    void refreshListYesLabel() {
        if (this.getDataType().isList()) {
            this.view.showListYesLabel();
        } else {
            this.view.hideListYesLabel();
        }
    }

    public void remove() {
        this.confirmation.ifIsNotReferencedDataType(this.getDataType(), this.doRemove());
    }

    Command doRemove() {
        return () -> {
            List<DataType> destroyedDataTypes = this.getDataType().destroy();
            List<DataType> removedDataTypes = this.removeTopLevelDataTypes(destroyedDataTypes);
            destroyedDataTypes.removeAll(removedDataTypes);
            this.dataTypeList.refreshItemsByUpdatedDataTypes(destroyedDataTypes);
            this.fireDataChangedEvent();
        };
    }

    List<DataType> removeTopLevelDataTypes(List<DataType> destroyedDataTypes) {
        return destroyedDataTypes.stream().filter(dataType -> dataType.isTopLevel() && (this.isDestroyedDataType((DataType)dataType) || this.isAReferenceToDestroyedDataType((DataType)dataType))).peek(this.dataTypeList::removeItem).collect(Collectors.toList());
    }

    private boolean isDestroyedDataType(DataType dataType) {
        return Objects.equals(dataType.getUUID(), this.getDataType().getUUID());
    }

    private boolean isAReferenceToDestroyedDataType(DataType dataType) {
        return this.getDataType().isTopLevel() && Objects.equals(dataType.getType(), this.getDataType().getName());
    }

    DataType updateProperties(DataType dataType) {
        return this.dataTypeManager.from(dataType).withName(this.getName()).withType(this.getType()).withConstraint(this.getConstraint()).withConstraintType(this.getConstraintType()).asList(this.isList()).get();
    }

    private String getConstraintType() {
        ConstraintType constraint = this.dataTypeConstraintComponent.getConstraintType();
        if (constraint == null) {
            return "";
        }
        return constraint.value();
    }

    private String getName() {
        return this.view.getName();
    }

    public String getType() {
        return this.dataTypeSelectComponent.getValue();
    }

    private String getConstraint() {
        return this.dataTypeConstraintComponent.getValue();
    }

    private boolean isList() {
        return this.dataTypeListComponent.getValue();
    }

    String getOldName() {
        return this.oldName;
    }

    String getOldType() {
        return this.oldType;
    }

    String getOldConstraint() {
        return this.oldConstraint;
    }

    String getOldConstraintType() {
        if (this.oldConstraintType == null) {
            return "";
        }
        return this.oldConstraintType.value();
    }

    boolean getOldIsList() {
        return this.oldIsList;
    }

    DataTypeList getDataTypeList() {
        return this.dataTypeList;
    }

    public void insertFieldAbove() {
        this.closeEditMode();
        DataType newDataType = this.newDataType();
        String referenceDataTypeHash = this.dataTypeList.calculateParentHash(this.getDataType());
        List<DataType> updatedDataTypes = newDataType.create(this.getDataType(), CreationType.ABOVE);
        if (newDataType.isTopLevel()) {
            this.dataTypeList.insertAbove(newDataType, this.getDataType());
        } else {
            this.dataTypeList.refreshItemsByUpdatedDataTypes(updatedDataTypes);
        }
        this.enableEditModeAndUpdateCallbacks(this.getNewDataTypeHash(newDataType, referenceDataTypeHash));
    }

    public void insertFieldBelow() {
        this.closeEditMode();
        DataType newDataType = this.newDataType();
        String referenceDataTypeHash = this.dataTypeList.calculateParentHash(this.getDataType());
        List<DataType> updatedDataTypes = newDataType.create(this.getDataType(), CreationType.BELOW);
        if (newDataType.isTopLevel()) {
            this.dataTypeList.insertBelow(newDataType, this.getDataType());
        } else {
            this.dataTypeList.refreshItemsByUpdatedDataTypes(updatedDataTypes);
        }
        this.enableEditModeAndUpdateCallbacks(this.getNewDataTypeHash(newDataType, referenceDataTypeHash));
    }

    public void insertNestedField() {
        this.closeEditMode();
        this.expand();
        DataType newDataType = this.newDataType();
        String referenceDataTypeHash = this.dataTypeList.calculateHash(this.getDataType());
        List<DataType> updatedDataTypes = newDataType.create(this.getDataType(), CreationType.NESTED);
        this.dataTypeList.refreshItemsByUpdatedDataTypes(updatedDataTypes);
        this.enableEditModeAndUpdateCallbacks(this.getNewDataTypeHash(newDataType, referenceDataTypeHash));
    }

    void enableEditModeAndUpdateCallbacks(String dataTypeHash) {
        this.dataTypeList.enableEditMode(dataTypeHash);
        this.dataTypeList.fireOnDataTypeListItemUpdateCallback(dataTypeHash);
    }

    String getNewDataTypeHash(DataType newDataType, String referenceDataTypeHash) {
        return Stream.of(referenceDataTypeHash, newDataType.getName()).filter(s -> !StringUtils.isEmpty((String)s)).collect(Collectors.joining("."));
    }

    private DataType newDataType() {
        return this.dataTypeManager.fromNew().get();
    }

    void refreshConstraintComponent() {
        if (this.canNotHaveConstraint()) {
            this.dataTypeConstraintComponent.disable();
        } else {
            this.dataTypeConstraintComponent.enable();
        }
    }

    private boolean canNotHaveConstraint() {
        if (this.isList()) {
            return true;
        }
        if (Stream.of(this.getCanNotHaveConstraintTypes()).filter(type -> Objects.equals(type, this.getType())).findFirst().isPresent()) {
            return true;
        }
        return this.isIndirectCanNotHaveConstraintType();
    }

    boolean isStructureType() {
        return Objects.equals(this.dataTypeManager.structure(), this.getType());
    }

    boolean isIndirectCanNotHaveConstraintType() {
        String currentValue = this.dataTypeSelectComponent.getValue();
        return this.isIndirectTypeOf(currentValue, this.getCanNotHaveConstraintTypes());
    }

    private boolean isIndirectTypeOf(String currentValue, String ... types) {
        List<DataType> customDataTypes = this.dataTypeSelectComponent.getCustomDataTypes();
        Optional<DataType> customType = customDataTypes.stream().filter(d -> d.getName().equals(currentValue)).findFirst();
        if (customType.isPresent()) {
            String type = customType.get().getType();
            return Arrays.stream(types).anyMatch(t -> t.equals(type)) || this.isIndirectTypeOf(type, types);
        }
        return false;
    }

    public static interface View
    extends UberElemental<DataTypeListItem> {
        public void setDataType(DataType var1);

        public void toggleArrow(boolean var1);

        public void expand();

        public void collapse();

        public void showEditButton();

        public void showSaveButton();

        public void setupSelectComponent(DataTypeSelect var1);

        public void setupConstraintComponent(DataTypeConstraint var1);

        public void setupListComponent(SmallSwitchComponent var1);

        public void showListContainer();

        public void hideListContainer();

        public void showListYesLabel();

        public void hideListYesLabel();

        public boolean isCollapsed();

        public void hideDataTypeNameInput();

        public void showDataTypeNameInput();

        public void enableFocusMode();

        public void disableFocusMode();

        public boolean isOnFocusMode();

        public String getName();

        public void setName(String var1);

        public void hideKebabMenu();

        public void showKebabMenu();
    }
}

