/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.confirmation;

import java.util.Objects;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.listview.confirmation.DataTypeHasFieldsWarningMessage;
import org.kie.workbench.common.dmn.client.editors.types.listview.confirmation.ReferencedDataTypeWarningMessage;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.ItemDefinitionStore;
import org.uberfire.mvp.Command;

@Dependent
public class DataTypeConfirmation {
    private final DataTypeStore dataTypeStore;
    private final ItemDefinitionStore itemDefinitionStore;
    private final Event<FlashMessage> flashMessageEvent;
    private final DataTypeHasFieldsWarningMessage dataTypeHasFieldsWarningMessage;
    private final ReferencedDataTypeWarningMessage referencedDataTypeWarningMessage;
    private final TranslationService translationService;

    @Inject
    public DataTypeConfirmation(DataTypeStore dataTypeStore, ItemDefinitionStore itemDefinitionStore, Event<FlashMessage> flashMessageEvent, DataTypeHasFieldsWarningMessage dataTypeHasFieldsWarningMessage, ReferencedDataTypeWarningMessage referencedDataTypeWarningMessage, TranslationService translationService) {
        this.dataTypeStore = dataTypeStore;
        this.itemDefinitionStore = itemDefinitionStore;
        this.flashMessageEvent = flashMessageEvent;
        this.dataTypeHasFieldsWarningMessage = dataTypeHasFieldsWarningMessage;
        this.referencedDataTypeWarningMessage = referencedDataTypeWarningMessage;
        this.translationService = translationService;
    }

    public void ifDataTypeDoesNotHaveLostSubDataTypes(DataType dataType, Command onSuccess, Command onError) {
        if (this.hasLostSubDataTypes(dataType)) {
            this.flashMessageEvent.fire((Object)this.dataTypeHasFieldsWarningMessage.getFlashMessage(dataType, onSuccess, onError));
        } else {
            onSuccess.execute();
        }
    }

    public void ifIsNotReferencedDataType(DataType dataType, Command onSuccess) {
        if (this.isReferencedByAnotherDataType(dataType)) {
            this.flashMessageEvent.fire((Object)this.referencedDataTypeWarningMessage.getFlashMessage(dataType, onSuccess, () -> {}));
        } else {
            onSuccess.execute();
        }
    }

    private boolean isReferencedByAnotherDataType(DataType dataType) {
        return this.dataTypeStore.all().stream().anyMatch(dt -> Objects.equals(dt.getType(), dataType.getName()));
    }

    private boolean hasLostSubDataTypes(DataType dataType) {
        ItemDefinition itemDefinition = this.itemDefinitionStore.get(dataType.getUUID());
        boolean isDataTypeNotStructure = !this.isStructure(dataType);
        boolean hasItemDefinitionSubItemDefinitions = !itemDefinition.getItemComponent().isEmpty();
        return isDataTypeNotStructure && hasItemDefinitionSubItemDefinitions;
    }

    private boolean isStructure(DataType dataType) {
        return Objects.equals(dataType.getType(), this.translationService.format("DataTypeManager.Structure", new Object[0]));
    }
}

