/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date;

import com.google.gwt.i18n.client.DateTimeFormat;
import java.util.Date;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class DateValueFormatter {
    static final String PREFIX = "date(\"";
    static final String SUFFIX = "\")";
    private static final DateTimeFormat RAW_FORMAT = DateTimeFormat.getFormat((String)"yyyy-MM-dd");
    private static final DateTimeFormat DISPLAY_FORMAT = DateTimeFormat.getFormat((String)"dd MMM yyyy");

    public String toDisplay(String rawValue) {
        if (StringUtils.isEmpty((String)rawValue)) {
            return "";
        }
        String dateString = this.removePrefixAndSuffix(rawValue);
        try {
            Date date = RAW_FORMAT.parse(dateString);
            return DISPLAY_FORMAT.format(date);
        }
        catch (IllegalArgumentException exception) {
            return "";
        }
    }

    String removePrefixAndSuffix(String rawValue) {
        return rawValue.replace(PREFIX, "").replace(SUFFIX, "").trim();
    }

    public String addPrefixAndSuffix(String value) {
        return PREFIX + value + SUFFIX;
    }

    String toRaw(String displayValue) {
        try {
            Date date = DISPLAY_FORMAT.parse(displayValue);
            return this.addPrefixAndSuffix(RAW_FORMAT.format(date));
        }
        catch (IllegalArgumentException exception) {
            return "";
        }
    }

    public String getDate(String raw) {
        return this.removePrefixAndSuffix(raw);
    }
}

