/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.time;

import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.DateValueFormatter;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.date.time.DateTimeValue;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimeValueFormatter;
import org.kie.workbench.common.stunner.core.util.StringUtils;

public class DateTimeValueConverter {
    static final String PREFIX = "date and time(\"";
    static final String SUFFIX = "\")";
    private static final int DATE_LENGTH = 10;
    private final DateValueFormatter dateValueFormatter;
    private final TimeValueFormatter timeValueFormatter;

    @Inject
    public DateTimeValueConverter(DateValueFormatter dateValueFormatter, TimeValueFormatter timeValueFormatter) {
        this.dateValueFormatter = dateValueFormatter;
        this.timeValueFormatter = timeValueFormatter;
    }

    public String toDMNString(DateTimeValue value) {
        if (!value.hasDate()) {
            return "";
        }
        String dmnString = this.getDate(value);
        if (value.hasTime()) {
            dmnString = dmnString + "T" + this.getTime(value);
        }
        return this.appendPrefixAndSuffix(dmnString);
    }

    String appendPrefixAndSuffix(String value) {
        return PREFIX + value + SUFFIX;
    }

    String removePrefixAndSuffix(String rawValue) {
        return rawValue.replace(PREFIX, "").replace(SUFFIX, "").trim();
    }

    String getTime(DateTimeValue value) {
        return this.timeValueFormatter.getTime(value.getTime());
    }

    String getDate(DateTimeValue value) {
        return this.dateValueFormatter.getDate(value.getDate());
    }

    public DateTimeValue fromDMNString(String dmnString) {
        String value = this.removePrefixAndSuffix(dmnString);
        String date = this.extractDate(value);
        String time = this.extractTime(value);
        DateTimeValue dateTimeValue = new DateTimeValue();
        dateTimeValue.setDate(this.dateValueFormatter.addPrefixAndSuffix(date));
        if (!StringUtils.isEmpty((String)time)) {
            dateTimeValue.setTime(this.timeValueFormatter.appendPrefixAndSuffix(time));
        }
        return dateTimeValue;
    }

    String extractTime(String value) {
        if (value.length() <= 11) {
            return "";
        }
        return value.substring(11);
    }

    String extractDate(String value) {
        return value.substring(0, 10);
    }

    public String toDisplay(String rawValue) {
        DateTimeValue value = this.fromDMNString(rawValue);
        String date = this.dateValueFormatter.toDisplay(value.getDate());
        if (value.hasTime()) {
            return date + ", " + this.timeValueFormatter.toDisplay(value.getTime());
        }
        return date;
    }
}

