/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.day.time;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONNull;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.common.DurationHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.day.time.DayTimeValue;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.client.views.pfly.widgets.MomentDuration;
import org.uberfire.client.views.pfly.widgets.MomentDurationObject;

public class DayTimeValueConverter {
    private final TranslationService translationService;

    @Inject
    public DayTimeValueConverter(TranslationService translationService) {
        this.translationService = translationService;
    }

    String toDMNString(DayTimeValue value) {
        JavaScriptObject properties = this.makeProperties(value.getDays(), value.getHours(), value.getMinutes(), value.getSeconds());
        return DurationHelper.addFunctionCall(MomentDuration.moment.duration(properties).toISOString());
    }

    DayTimeValue fromDMNString(String dmnString) {
        MomentDurationObject duration = MomentDuration.moment.duration(DurationHelper.getFunctionParameter(dmnString));
        return new DayTimeValue(duration.days(), duration.hours(), duration.minutes(), duration.seconds());
    }

    String toDisplayValue(String dmnString) {
        DayTimeValue value = this.fromDMNString(dmnString);
        String daysLabel = this.pluralize(value.getDays(), "DayTimeValueConverter.Day", "DayTimeValueConverter.Days");
        String hoursLabel = this.pluralize(value.getHours(), "DayTimeValueConverter.Hour", "DayTimeValueConverter.Hours");
        String minutesLabel = this.pluralize(value.getMinutes(), "DayTimeValueConverter.Minute", "DayTimeValueConverter.Minutes");
        String secondsLabel = this.pluralize(value.getSeconds(), "DayTimeValueConverter.Second", "DayTimeValueConverter.Seconds");
        return Stream.of(daysLabel, hoursLabel, minutesLabel, secondsLabel).filter(e -> !StringUtils.isEmpty((String)e)).collect(Collectors.joining(", "));
    }

    private JavaScriptObject makeProperties(Integer days, Integer hours, Integer minutes, Integer seconds) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("days", this.number(days));
        jsonObject.put("hours", this.number(hours));
        jsonObject.put("minutes", this.number(minutes));
        jsonObject.put("seconds", this.number(seconds));
        return jsonObject.getJavaScriptObject();
    }

    JSONValue number(Integer value) {
        return Objects.isNull(value) ? JSONNull.getInstance() : new JSONNumber((double)value.intValue());
    }

    private String pluralize(int value, String singular, String plural) {
        if (value == 1) {
            return value + " " + this.translationService.format(singular, new Object[0]);
        }
        return value + " " + this.translationService.format(plural, new Object[0]);
    }
}

