/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker;

import elemental2.dom.Element;
import elemental2.dom.Event;
import elemental2.dom.FocusEvent;
import elemental2.dom.HTMLElement;
import elemental2.dom.HTMLInputElement;
import elemental2.dom.Node;
import java.util.Objects;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.client.editors.types.common.HiddenHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.typed.time.picker.TimePickerView;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.client.views.pfly.selectpicker.ElementHelper;
import org.uberfire.client.views.pfly.selectpicker.JQuery;
import org.uberfire.client.views.pfly.widgets.Moment;

@Dependent
public class TimePicker {
    static final String TIME_FORMAT = "HH:mm:ss";
    private final View view;
    private HTMLInputElement inputBind;
    private Element.OnblurCallbackFn previousCallback;
    private Consumer<Moment> onDateChanged;

    @Inject
    public TimePicker(View view) {
        this.view = view;
    }

    public void bind(HTMLInputElement input) {
        this.inputBind = input;
        HTMLElement viewElement = this.view.getElement();
        ElementHelper.insertAfter((Node)viewElement, (Node)input);
        input.onclick = this::inputOnClick;
        this.previousCallback = input.onblur;
        input.onblur = this::inputOnBlur;
        viewElement.scrollTop = input.scrollTop;
        viewElement.scrollLeft = input.scrollLeft;
        this.view.setOnBlur(this::onViewElementBlur);
        this.view.setOnDateChanged(this::onDateChanged);
    }

    HTMLInputElement getInputBind() {
        return this.inputBind;
    }

    void refreshDateInPopup() {
        if (this.isDateSetInInput()) {
            Moment moment = this.getDateInInput();
            if (moment.isValid()) {
                this.view.setDate(moment);
            }
        } else {
            this.setDefaultData();
        }
    }

    Moment getDateInInput() {
        return Moment.Builder.moment((String)this.getInputBind().value, (String)TIME_FORMAT);
    }

    boolean isDateSetInInput() {
        return !StringUtils.isEmpty((String)this.getInputBind().value) && !StringUtils.isEmpty((String)this.getInputBind().value.trim()) && this.getInputBind().value.contains(":");
    }

    void setDefaultData() {
        Moment now = Moment.Builder.moment();
        this.view.setDate(now);
    }

    void onDateChanged(Moment nativeDate) {
        this.getInputBind().value = nativeDate.format(TIME_FORMAT);
        if (!Objects.isNull(this.onDateChanged)) {
            this.onDateChanged.accept(nativeDate);
        }
    }

    public void setOnDateChanged(Consumer<Moment> onDateChanged) {
        this.onDateChanged = onDateChanged;
    }

    Object inputOnClick(Event event) {
        this.refreshDateInPopup();
        this.view.getElement().style.top = JQuery.$((Node)this.inputBind).offset().top - 5.0 + "px";
        HiddenHelper.show((Element)this.view.getElement());
        return this;
    }

    private Object onViewElementBlur(Event event) {
        FocusEvent focusEvent = (FocusEvent)event;
        this.onBlur(focusEvent, (HTMLElement)this.getInputBind());
        return this;
    }

    private Object inputOnBlur(Event event) {
        FocusEvent focusEvent = (FocusEvent)event;
        this.onBlur(focusEvent, this.view.getElement());
        return this;
    }

    private void onBlur(FocusEvent focusEvent, HTMLElement targetElement) {
        if (!Objects.equals(focusEvent.relatedTarget, targetElement) && !this.isChildOfView((Element)focusEvent.relatedTarget)) {
            HiddenHelper.hide((Element)this.view.getElement());
            if (!Objects.isNull(this.previousCallback)) {
                this.previousCallback.onInvoke((Event)focusEvent);
            }
        }
    }

    boolean isChildOfView(Element element) {
        HTMLElement viewElement = this.view.getElement();
        return viewElement.contains((Node)element);
    }

    public String getValue() {
        Moment currentDate = this.view.getDate();
        if (Objects.isNull(currentDate)) {
            return "";
        }
        return currentDate.format(TIME_FORMAT);
    }

    public void setValue(String value) {
        Moment moment = Moment.Builder.moment((String)value, (String)TIME_FORMAT);
        if (moment.isValid()) {
            this.view.setDate(moment);
        }
    }

    public static interface View
    extends UberElemental<TimePickerView>,
    IsElement {
        public void setDate(Moment var1);

        public void setOnDateChanged(Consumer<Moment> var1);

        public Moment getDate();

        public void setOnBlur(Consumer<Event> var1);
    }
}

