/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.item;

import elemental2.dom.Element;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.ConstraintPlaceholderHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.enumeration.DataTypeConstraintEnumeration;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.client.mvp.UberElemental;
import org.uberfire.mvp.Command;

@Dependent
public class DataTypeConstraintEnumerationItem {
    static final String NULL = "null";
    private final View view;
    private final ConstraintPlaceholderHelper placeholderHelper;
    private DataTypeConstraintEnumeration dataTypeConstraintEnumeration;
    private String value;
    private String oldValue;

    @Inject
    public DataTypeConstraintEnumerationItem(View view, ConstraintPlaceholderHelper placeholderHelper) {
        this.view = view;
        this.placeholderHelper = placeholderHelper;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    public void setValue(String newValue) {
        this.setNonNullValue(newValue);
        this.view.setValue(this.getValue());
    }

    public String getValue() {
        return this.value;
    }

    public int getOrder() {
        return this.view.getOrder();
    }

    public Element getElement() {
        return this.view.getElement();
    }

    public void enableEditMode() {
        this.setOldValue(this.getValue());
        this.view.showValueInput();
        this.view.focusValueInput();
        this.view.enableHighlight();
        this.view.showSaveButton();
        this.view.showClearButton();
        this.view.hideDeleteButton();
    }

    public void disableEditMode() {
        this.view.showValueText();
        this.view.disableHighlight();
        this.view.hideSaveButton();
        this.view.hideClearButton();
        this.view.showDeleteButton();
    }

    public void save(String newValue) {
        this.setNonNullValue(newValue);
        this.refreshEnumerationListAndScrollToThisItem();
    }

    public void remove() {
        this.getEnumerationItems().remove(this);
        this.refreshEnumerationList();
    }

    void discardEditMode() {
        this.setValue(this.getOldValue());
        this.disableEditMode();
    }

    private List<DataTypeConstraintEnumerationItem> getEnumerationItems() {
        return this.dataTypeConstraintEnumeration.getEnumerationItems();
    }

    private void refreshEnumerationList() {
        this.dataTypeConstraintEnumeration.refreshView();
    }

    private void refreshEnumerationListAndScrollToThisItem() {
        this.dataTypeConstraintEnumeration.refreshView(this.getScrollToThisItemCallback());
    }

    Command getScrollToThisItemCallback() {
        return () -> this.dataTypeConstraintEnumeration.scrollToPosition(this.getOrder());
    }

    void setOldValue(String value) {
        this.oldValue = value;
    }

    String getOldValue() {
        return this.oldValue;
    }

    public void setDataTypeConstraintEnumeration(DataTypeConstraintEnumeration dataTypeConstraintEnumeration) {
        this.dataTypeConstraintEnumeration = dataTypeConstraintEnumeration;
    }

    public void setConstraintValueType(String constraintValueType) {
        this.view.setComponentSelector(constraintValueType);
        this.view.setPlaceholder(this.placeholderHelper.getPlaceholderSample(constraintValueType));
    }

    private void setNonNullValue(String newValue) {
        this.value = StringUtils.isEmpty((String)newValue) ? NULL : newValue;
    }

    public void setOrder(int order) {
        this.view.setOrder(order);
    }

    public static interface View
    extends UberElemental<DataTypeConstraintEnumerationItem>,
    IsElement {
        public void showValueText();

        public void showValueInput();

        public void focusValueInput();

        public void showSaveButton();

        public void hideSaveButton();

        public void enableHighlight();

        public void disableHighlight();

        public void setValue(String var1);

        public void setPlaceholder(String var1);

        public void setComponentSelector(String var1);

        public void showClearButton();

        public void hideDeleteButton();

        public void hideClearButton();

        public void showDeleteButton();

        public int getOrder();

        public void setOrder(int var1);
    }
}

