/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.constraint.range;

import elemental2.dom.Element;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ui.client.local.api.elemental2.IsElement;
import org.kie.workbench.common.dmn.api.editors.types.RangeValue;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.DataTypeConstraintModal;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.ConstraintPlaceholderHelper;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.DataTypeConstraintComponent;
import org.kie.workbench.common.dmn.client.editors.types.listview.constraint.common.DataTypeConstraintParserWarningEvent;
import org.kie.workbench.common.dmn.client.service.DMNClientServicesProxy;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.client.mvp.UberElemental;

@Dependent
public class DataTypeConstraintRange
implements DataTypeConstraintComponent {
    private final View view;
    private final ConstraintPlaceholderHelper placeholderHelper;
    private final DMNClientServicesProxy clientServicesProxy;
    private final Event<DataTypeConstraintParserWarningEvent> parserWarningEvent;
    private DataTypeConstraintModal modal;

    @Inject
    public DataTypeConstraintRange(View view, ConstraintPlaceholderHelper placeholderHelper, DMNClientServicesProxy clientServicesProxy, Event<DataTypeConstraintParserWarningEvent> parserWarningEvent) {
        this.view = view;
        this.placeholderHelper = placeholderHelper;
        this.clientServicesProxy = clientServicesProxy;
        this.parserWarningEvent = parserWarningEvent;
    }

    @PostConstruct
    void setup() {
        this.view.init(this);
    }

    @Override
    public String getValue() {
        return this.getRawValue();
    }

    @Override
    public void setValue(String value) {
        this.clientServicesProxy.parseRangeValue(value, new ServiceCallback<RangeValue>(){

            public void onSuccess(RangeValue item) {
                DataTypeConstraintRange.this.loadConstraintValue(item);
            }

            public void onError(ClientRuntimeError error) {
                DataTypeConstraintRange.this.showWarningMessage();
                DataTypeConstraintRange.this.loadConstraintValue(new RangeValue());
            }
        });
    }

    @Override
    public void setConstraintValueType(String type) {
        this.view.setComponentSelector(type);
        this.view.setPlaceholders(this.placeholderHelper.getPlaceholderSample(type));
    }

    private void showWarningMessage() {
        this.parserWarningEvent.fire((Object)new DataTypeConstraintParserWarningEvent());
    }

    void loadConstraintValue(RangeValue rangeValue) {
        this.view.setIncludeStartValue(rangeValue.getIncludeStartValue());
        this.view.setStartValue(rangeValue.getStartValue());
        this.view.setEndValue(rangeValue.getEndValue());
        this.view.setIncludeEndValue(rangeValue.getIncludeEndValue());
        if (!StringUtils.isEmpty((String)rangeValue.getStartValue()) && !StringUtils.isEmpty((String)rangeValue.getEndValue())) {
            this.enableOkButton();
        } else {
            this.disableOkButton();
        }
    }

    @Override
    public Element getElement() {
        return this.view.getElement();
    }

    private String getRawValue() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.view.getIncludeStartValue() ? "[" : "(");
        builder.append(this.view.getStartValue());
        builder.append("..");
        builder.append(this.view.getEndValue());
        builder.append(this.view.getIncludeEndValue() ? "]" : ")");
        return builder.toString();
    }

    void disableOkButton() {
        this.modal.disableOkButton();
    }

    void enableOkButton() {
        this.modal.enableOkButton();
    }

    public void setModal(DataTypeConstraintModal modal) {
        this.modal = modal;
    }

    public static interface View
    extends UberElemental<DataTypeConstraintRange>,
    IsElement {
        public String getStartValue();

        public String getEndValue();

        public void setStartValue(String var1);

        public void setEndValue(String var1);

        public boolean getIncludeStartValue();

        public void setIncludeStartValue(boolean var1);

        public boolean getIncludeEndValue();

        public void setIncludeEndValue(boolean var1);

        public void setPlaceholders(String var1);

        public void setComponentSelector(String var1);
    }
}

