/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.listview.validation;

import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.client.editors.common.messages.FlashMessage;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.errors.DataTypeNameIsInvalidErrorMessage;
import org.kie.workbench.common.dmn.client.service.DMNClientServicesProxy;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.uberfire.mvp.Command;

@Dependent
public class DataTypeNameFormatValidator {
    private final DMNClientServicesProxy clientServicesProxy;
    private final Event<FlashMessage> flashMessageEvent;
    private final DataTypeNameIsInvalidErrorMessage nameIsInvalidErrorMessage;

    @Inject
    public DataTypeNameFormatValidator(DMNClientServicesProxy clientServicesProxy, Event<FlashMessage> flashMessageEvent, DataTypeNameIsInvalidErrorMessage nameIsInvalidErrorMessage) {
        this.clientServicesProxy = clientServicesProxy;
        this.flashMessageEvent = flashMessageEvent;
        this.nameIsInvalidErrorMessage = nameIsInvalidErrorMessage;
    }

    public void ifIsValid(DataType dataType, Command onSuccess) {
        String dataTypeName = dataType.getName();
        this.clientServicesProxy.isValidVariableName(dataTypeName, this.getCallback(dataType, onSuccess));
    }

    ServiceCallback<Boolean> getCallback(final DataType dataType, final Command onSuccess) {
        return new ServiceCallback<Boolean>(){

            public void onSuccess(Boolean isValid) {
                if (isValid.booleanValue()) {
                    onSuccess.execute();
                } else {
                    DataTypeNameFormatValidator.this.flashMessageEvent.fire((Object)DataTypeNameFormatValidator.this.nameIsInvalidErrorMessage.getFlashMessage(dataType));
                }
            }

            public void onError(ClientRuntimeError error) {
                DataTypeNameFormatValidator.this.clientServicesProxy.logWarning(error);
            }
        };
    }
}

