/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.editors.types.persistence.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.dmn.api.definition.model.ItemDefinition;
import org.kie.workbench.common.dmn.api.editors.types.BuiltInTypeUtils;
import org.kie.workbench.common.dmn.client.editors.types.common.DataType;
import org.kie.workbench.common.dmn.client.editors.types.common.DataTypeManager;
import org.kie.workbench.common.dmn.client.editors.types.persistence.CreationType;
import org.kie.workbench.common.dmn.client.editors.types.persistence.DataTypeStore;
import org.kie.workbench.common.dmn.client.editors.types.persistence.handlers.DataTypeHandler;

@Dependent
public class DataTypeCreateHandler
extends DataTypeHandler {
    @Inject
    public DataTypeCreateHandler(DataTypeStore dataTypeStore, DataTypeManager dataTypeManager) {
        super(dataTypeStore, dataTypeManager);
    }

    public List<DataType> append(DataType dataType, ItemDefinition itemDefinition) {
        DataType updateDataType = this.updateDataTypeProperties(dataType, "", itemDefinition);
        return this.recordEngine.update(updateDataType);
    }

    public List<DataType> insertNested(DataType dataType, DataType reference, ItemDefinition itemDefinition) {
        String parentUUID = reference.getUUID();
        DataType updatedDataType = this.updateDataTypeProperties(dataType, parentUUID, itemDefinition);
        Optional<DataType> topLevelReference = this.fetchTopLevelDataType(reference);
        DataType parent = topLevelReference.orElse(reference);
        if (BuiltInTypeUtils.isBuiltInType((String)reference.getType()) || topLevelReference.isPresent()) {
            this.dataTypeManager.withDataType(parent).asStructure();
        }
        parent.getSubDataTypes().add(0, updatedDataType);
        return this.recordEngine.update(dataType);
    }

    public List<DataType> insert(DataType dataType, DataType reference, CreationType creationType, ItemDefinition itemDefinition) {
        Optional<DataType> parentOptional = this.lookupAbsoluteParent(reference);
        if (parentOptional.isPresent()) {
            DataType parent = parentOptional.get();
            List<DataType> siblings = parent.getSubDataTypes();
            DataType updatedDataType = this.updateDataTypeProperties(dataType, parent.getUUID(), itemDefinition);
            DataType parentReference = this.findParentReference(reference, siblings);
            siblings.add(siblings.indexOf(parentReference) + creationType.getIndexIncrement(), updatedDataType);
            this.recordEngine.doUpdate(dataType, itemDefinition);
            return this.recordEngine.update(parent);
        }
        DataType updatedDataType = this.updateDataTypeProperties(dataType, reference.getParentUUID(), itemDefinition);
        this.recordEngine.doUpdate(updatedDataType, itemDefinition);
        return new ArrayList<DataType>();
    }

    Optional<DataType> lookupAbsoluteParent(DataType reference) {
        Optional<DataType> optionalParent = Optional.ofNullable(this.parent(reference));
        if (optionalParent.isPresent()) {
            return this.fetchTopLevelDataType(optionalParent.get());
        }
        return Optional.empty();
    }

    private Optional<DataType> fetchTopLevelDataType(DataType dataType) {
        if (Objects.equals(dataType.getType(), this.dataTypeManager.structure())) {
            return Optional.of(dataType);
        }
        return this.dataTypeStore.getTopLevelDataTypes().stream().filter(dt -> Objects.equals(dt.getName(), dataType.getType())).findFirst();
    }

    DataType updateDataTypeProperties(DataType dataType, String parentUUID, ItemDefinition itemDefinition) {
        return this.dataTypeManager.withDataType(dataType).withParentUUID(parentUUID).withNoName().withItemDefinition(itemDefinition).withIndexedItemDefinition().get();
    }

    private DataType findParentReference(DataType reference, List<DataType> siblings) {
        return siblings.stream().filter(dataType -> Objects.equals(dataType.getName(), reference.getName())).findFirst().orElseThrow(() -> new UnsupportedOperationException("The 'siblings' (from the 'AbsoluteParent') must have a Data Type with the same name as the 'reference' instance since they represent the same type."));
    }
}

