/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.shape.view.decisionservice;

import com.ait.lienzo.client.core.animation.AnimationProperty;
import com.ait.lienzo.client.core.event.AbstractNodeDragEvent;
import com.ait.lienzo.client.core.event.NodeDragEndEvent;
import com.ait.lienzo.client.core.event.NodeDragEndHandler;
import com.ait.lienzo.client.core.event.NodeDragMoveEvent;
import com.ait.lienzo.client.core.event.NodeDragStartEvent;
import com.ait.lienzo.client.core.shape.AbstractMultiPathPartShape;
import com.ait.lienzo.client.core.shape.Circle;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.Layer;
import com.ait.lienzo.client.core.shape.MultiPath;
import com.ait.lienzo.client.core.shape.Shape;
import com.ait.lienzo.client.core.shape.wires.AbstractControlHandle;
import com.ait.lienzo.client.core.shape.wires.IControlHandle;
import com.ait.lienzo.client.core.shape.wires.IControlHandleFactory;
import com.ait.lienzo.client.core.shape.wires.IControlHandleList;
import com.ait.lienzo.client.core.shape.wires.event.WiresResizeStepEvent;
import com.ait.lienzo.client.core.types.DragBounds;
import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.client.widget.DefaultDragConstraintEnforcer;
import com.ait.lienzo.client.widget.DragConstraintEnforcer;
import com.ait.lienzo.client.widget.DragContext;
import com.ait.lienzo.shared.core.types.DragConstraint;
import com.ait.lienzo.shared.core.types.DragMode;
import com.ait.lienzo.shared.core.types.IColor;
import com.ait.tooling.nativetools.client.event.HandlerRegistrationManager;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.kie.workbench.common.dmn.client.shape.view.decisionservice.DecisionServiceDividerLine;
import org.kie.workbench.common.dmn.client.shape.view.decisionservice.MoveDividerEndEvent;
import org.kie.workbench.common.dmn.client.shape.view.decisionservice.MoveDividerEndHandler;
import org.kie.workbench.common.dmn.client.shape.view.decisionservice.MoveDividerStartEvent;
import org.kie.workbench.common.dmn.client.shape.view.decisionservice.MoveDividerStartHandler;
import org.kie.workbench.common.dmn.client.shape.view.decisionservice.MoveDividerStepEvent;
import org.kie.workbench.common.dmn.client.shape.view.decisionservice.MoveDividerStepHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGPrimitive;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGPrimitiveShape;
import org.kie.workbench.common.stunner.svg.client.shape.view.impl.SVGShapeViewImpl;

public class DecisionServiceSVGShapeView
extends SVGShapeViewImpl {
    private final DecisionServiceDividerLine divider;
    private final HandlerRegistrationManager registrationManager = new HandlerRegistrationManager();
    private final DecisionServiceControlHandleFactory decisionServiceControlHandleFactory;

    public DecisionServiceSVGShapeView(String name, SVGPrimitiveShape svgPrimitive, double width, double height, boolean resizable) {
        super(name, svgPrimitive, width, height, resizable);
        MultiPath shape = this.getPath();
        this.divider = new DecisionServiceDividerLine(() -> DecisionServiceSVGShapeView.lambda$new$0((Shape)shape));
        this.decisionServiceControlHandleFactory = new DecisionServiceControlHandleFactory(this.divider, shape.getControlHandleFactory(), () -> DecisionServiceSVGShapeView.lambda$new$1((Shape)shape), () -> DecisionServiceSVGShapeView.lambda$new$2((Shape)shape));
        shape.setControlHandleFactory((IControlHandleFactory)this.decisionServiceControlHandleFactory);
        this.addChild((SVGPrimitive)this.divider.asSVGPrimitiveShape());
        this.addWiresResizeStepHandler(arg_0 -> this.lambda$new$4((Shape)shape, arg_0));
    }

    public DecisionServiceSVGShapeView addDividerDragHandler(DragHandler dragHandler) {
        HandlerManager handlerManager = this.getHandlerManager();
        HandlerRegistration dragStartRegistration = handlerManager.addHandler(MoveDividerStartEvent.TYPE, (EventHandler)((MoveDividerStartHandler)event -> dragHandler.start(this.buildDragEvent(event))));
        HandlerRegistration dragStepRegistration = handlerManager.addHandler(MoveDividerStepEvent.TYPE, (EventHandler)((MoveDividerStepHandler)event -> dragHandler.handle((ViewEvent)this.buildDragEvent(event))));
        HandlerRegistration dragEndRegistration = handlerManager.addHandler(MoveDividerEndEvent.TYPE, (EventHandler)((MoveDividerEndHandler)event -> dragHandler.end(this.buildDragEvent(event))));
        HandlerRegistration[] registrations = new HandlerRegistration[]{dragStartRegistration, dragStepRegistration, dragEndRegistration};
        this.getEventHandlerManager().addHandlersRegistration(ViewEventType.DRAG, registrations);
        return this;
    }

    public double getDividerLineY() {
        return this.divider.getY();
    }

    public void setDividerLineY(double y) {
        this.divider.setY(y);
        this.decisionServiceControlHandleFactory.getMoveDividerControlHandle().ifPresent(handle -> handle.getControl().setY(y));
    }

    public HandlerManager getHandlerManager() {
        return super.getHandlerManager();
    }

    public void destroy() {
        this.registrationManager.destroy();
        super.destroy();
    }

    private /* synthetic */ void lambda$new$4(Shape shape, WiresResizeStepEvent event) {
        this.decisionServiceControlHandleFactory.getMoveDividerControlHandle().ifPresent(handle -> handle.getControl().setX(shape.getBoundingBox().getWidth() / 2.0));
    }

    private static /* synthetic */ Double lambda$new$2(Shape shape) {
        return shape.getBoundingBox().getHeight();
    }

    private static /* synthetic */ Double lambda$new$1(Shape shape) {
        return shape.getBoundingBox().getWidth();
    }

    private static /* synthetic */ Double lambda$new$0(Shape shape) {
        return shape.getBoundingBox().getWidth();
    }

    static class MoveDividerDragHandler
    implements DragConstraintEnforcer,
    NodeDragEndHandler {
        private final Circle controlShape;
        private final IControlHandleList resizeControlHandles;
        private final MoveDividerControlHandle moveDividerControlHandle;
        private final Supplier<Double> dragBoundsWidthSupplier;
        private final Supplier<Double> dragBoundsHeightSupplier;
        private final DragConstraintEnforcer delegateDragConstraintEnforcer = new DefaultDragConstraintEnforcer();

        MoveDividerDragHandler(Circle controlShape, IControlHandleList resizeControlHandles, MoveDividerControlHandle moveDividerControlHandle, Supplier<Double> dragBoundsWidthSupplier, Supplier<Double> dragBoundsHeightSupplier) {
            this.controlShape = controlShape;
            this.resizeControlHandles = resizeControlHandles;
            this.moveDividerControlHandle = moveDividerControlHandle;
            this.dragBoundsWidthSupplier = dragBoundsWidthSupplier;
            this.dragBoundsHeightSupplier = dragBoundsHeightSupplier;
        }

        public void startDrag(DragContext dragContext) {
            dragContext.getNode().setDragBounds(this.makeDragBounds());
            this.delegateDragConstraintEnforcer.startDrag(dragContext);
            if (this.moveDividerControlHandle.isActive() && this.resizeControlHandles.isActive()) {
                this.controlShape.setFillColor((IColor)AbstractMultiPathPartShape.CONTROL_POINT_DRAG_FILL);
                this.doSafeDraw();
            }
        }

        public boolean adjust(Point2D dxy) {
            return this.delegateDragConstraintEnforcer.adjust(dxy);
        }

        public void onNodeDragEnd(NodeDragEndEvent event) {
            if (this.moveDividerControlHandle.isActive() && this.resizeControlHandles.isActive()) {
                this.controlShape.setFillColor((IColor)AbstractMultiPathPartShape.CONTROL_POINT_ACTIVE_FILL);
                this.doSafeDraw();
            }
        }

        private void doSafeDraw() {
            Optional.ofNullable(this.controlShape.getLayer()).ifPresent(Layer::draw);
        }

        private DragBounds makeDragBounds() {
            double width = this.dragBoundsWidthSupplier.get();
            double height = this.dragBoundsHeightSupplier.get();
            return new DragBounds(0.0, 50.0, width, height - 50.0);
        }
    }

    static class MoveDividerControlHandle
    extends AbstractControlHandle {
        private final Circle controlShape;

        public MoveDividerControlHandle(Circle controlShape, IControlHandleList resizeControlHandles, Supplier<Double> dragBoundsWidthSupplier, Supplier<Double> dragBoundsHeightSupplier) {
            this.controlShape = controlShape;
            MoveDividerDragHandler handler = new MoveDividerDragHandler(controlShape, resizeControlHandles, this, dragBoundsWidthSupplier, dragBoundsHeightSupplier);
            controlShape.setDragConstraints((DragConstraintEnforcer)handler);
            this.register(controlShape.addNodeDragEndHandler((NodeDragEndHandler)handler));
        }

        public IPrimitive<?> getControl() {
            return this.controlShape;
        }

        public void destroy() {
            super.destroy();
        }

        public IControlHandle.ControlHandleType getType() {
            return IControlHandle.ControlHandleStandardType.RESIZE;
        }
    }

    class DecisionServiceControlHandleFactory
    implements IControlHandleFactory {
        private final DecisionServiceDividerLine divider;
        private final IControlHandleFactory delegateControlHandleFactory;
        private final Supplier<Double> dragBoundsWidthSupplier;
        private final Supplier<Double> dragBoundsHeightSupplier;
        private Optional<MoveDividerControlHandle> moveDividerControlHandle = Optional.empty();

        DecisionServiceControlHandleFactory(DecisionServiceDividerLine divider, IControlHandleFactory delegateControlHandleFactory, Supplier<Double> dragBoundsWidthSupplier, Supplier<Double> dragBoundsHeightSupplier) {
            this.divider = divider;
            this.delegateControlHandleFactory = delegateControlHandleFactory;
            this.dragBoundsWidthSupplier = dragBoundsWidthSupplier;
            this.dragBoundsHeightSupplier = dragBoundsHeightSupplier;
        }

        Optional<MoveDividerControlHandle> getMoveDividerControlHandle() {
            return this.moveDividerControlHandle;
        }

        public Map<IControlHandle.ControlHandleType, IControlHandleList> getControlHandles(IControlHandle.ControlHandleType ... types) {
            Map controlHandles = this.delegateControlHandleFactory.getControlHandles(types);
            this.appendMoveDividerControlPoint(controlHandles);
            return controlHandles;
        }

        public Map<IControlHandle.ControlHandleType, IControlHandleList> getControlHandles(List<IControlHandle.ControlHandleType> types) {
            Map controlHandles = this.delegateControlHandleFactory.getControlHandles(types);
            this.appendMoveDividerControlPoint(controlHandles);
            return controlHandles;
        }

        private void appendMoveDividerControlPoint(Map<IControlHandle.ControlHandleType, IControlHandleList> controlHandles) {
            IControlHandleList resizeControlHandles = controlHandles.get(IControlHandle.ControlHandleStandardType.RESIZE);
            if (!this.moveDividerControlHandle.isPresent()) {
                this.moveDividerControlHandle = Optional.of(this.getMoveDividerControlHandle(this.divider, resizeControlHandles, new Point2D(this.dragBoundsWidthSupplier.get() / 2.0, 0.0)));
                this.setupMoveDividerEventHandlers();
            }
            resizeControlHandles.add((IControlHandle)this.moveDividerControlHandle.get());
        }

        private void setupMoveDividerEventHandlers() {
            this.moveDividerControlHandle.ifPresent(handle -> {
                IPrimitive<?> control = handle.getControl();
                DecisionServiceSVGShapeView.this.registrationManager.register(control.addNodeDragStartHandler(this::moveDividerStart));
                DecisionServiceSVGShapeView.this.registrationManager.register(control.addNodeDragMoveHandler(this::moveDividerMove));
                DecisionServiceSVGShapeView.this.registrationManager.register(control.addNodeDragEndHandler(this::moveDividerEnd));
            });
        }

        private void moveDividerStart(NodeDragStartEvent event) {
            this.fireMoveDividerEvent((GwtEvent<?>)new MoveDividerStartEvent(DecisionServiceSVGShapeView.this, (AbstractNodeDragEvent<?>)event));
        }

        private void moveDividerMove(NodeDragMoveEvent event) {
            this.fireMoveDividerEvent((GwtEvent<?>)new MoveDividerStepEvent(DecisionServiceSVGShapeView.this, (AbstractNodeDragEvent<?>)event));
        }

        private void moveDividerEnd(NodeDragEndEvent event) {
            this.fireMoveDividerEvent((GwtEvent<?>)new MoveDividerEndEvent(DecisionServiceSVGShapeView.this, (AbstractNodeDragEvent<?>)event));
        }

        private void fireMoveDividerEvent(GwtEvent<?> event) {
            this.moveDividerControlHandle.ifPresent(handle -> {
                this.divider.setY(handle.getControl().getY());
                DecisionServiceSVGShapeView.this.getHandlerManager().fireEvent(event);
            });
        }

        private MoveDividerControlHandle getMoveDividerControlHandle(DecisionServiceDividerLine divider, IControlHandleList resizeControlHandles, Point2D controlPointOffset) {
            Circle controlShape = (Circle)AbstractMultiPathPartShape.DefaultMultiPathShapeHandleFactory.getControlPrimitive((double)5.0, (double)controlPointOffset.getX(), (double)controlPointOffset.getY(), (Shape)divider, (DragMode)DragMode.SAME_LAYER).setDragConstraint(DragConstraint.VERTICAL);
            MoveDividerControlHandle handle = new MoveDividerControlHandle(controlShape, resizeControlHandles, this.dragBoundsWidthSupplier, this.dragBoundsHeightSupplier);
            AbstractMultiPathPartShape.DefaultMultiPathShapeHandleFactory.animate((AbstractControlHandle)handle, (AnimationProperty)AnimationProperty.Properties.RADIUS((double)10.0), (AnimationProperty)AnimationProperty.Properties.RADIUS((double)5.0));
            return handle;
        }
    }
}

