/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.widgets.grid.controls.list;

import java.util.List;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.dom.HTMLElement;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.HasListSelectorControl;
import org.kie.workbench.common.dmn.client.widgets.grid.controls.list.ListSelectorView;

@Dependent
public class ListSelector
implements ListSelectorView.Presenter {
    private ListSelectorView view;
    private Optional<HasListSelectorControl> binding = Optional.empty();

    public ListSelector() {
    }

    @Inject
    public ListSelector(ListSelectorView view) {
        this.view = view;
        this.view.init(this);
    }

    public HTMLElement getElement() {
        return this.view.getElement();
    }

    @Override
    public void onItemSelected(HasListSelectorControl.ListSelectorItem item) {
        this.binding.ifPresent(b -> b.onItemSelected(item));
    }

    @Override
    public void bind(HasListSelectorControl bound, int uiRowIndex, int uiColumnIndex) {
        this.binding = Optional.ofNullable(bound);
        this.binding.ifPresent(b -> {
            List<HasListSelectorControl.ListSelectorItem> items = b.getItems(uiRowIndex, uiColumnIndex);
            if (items.isEmpty()) {
                this.bind(null, uiRowIndex, uiColumnIndex);
            } else {
                this.view.setItems(b.getItems(uiRowIndex, uiColumnIndex));
            }
        });
    }

    @Override
    public void show(Optional<String> editorTitle) {
        this.binding.ifPresent(b -> this.view.show());
    }

    @Override
    public void hide() {
        this.binding.ifPresent(b -> this.view.hide());
    }
}

