/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.dmn.client.api;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.kie.workbench.common.dmn.client.service.DMNClientServicesProxy;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;

public abstract class DMNServiceClient {
    protected final DMNClientServicesProxy clientServicesProxy;

    public DMNServiceClient(DMNClientServicesProxy clientServicesProxy) {
        this.clientServicesProxy = clientServicesProxy;
    }

    public <T> ServiceCallback<List<T>> callback(final Consumer<List<T>> consumer) {
        return new ServiceCallback<List<T>>(){

            public void onSuccess(List<T> item) {
                consumer.accept(item);
            }

            public void onError(ClientRuntimeError error) {
                DMNServiceClient.this.getClientServicesProxy().logWarning(error);
                consumer.accept(new ArrayList());
            }
        };
    }

    DMNClientServicesProxy getClientServicesProxy() {
        return this.clientServicesProxy;
    }
}

